local customTonemapEnum = {
    uniform = 100,
    rgb = 101,
}

local color_red = {1,0,0}
local color_orange = {1,0.5,0}
local color_yellow = {1,1,0}
local color_green = {0,1,0}
local color_dark_green = {0,0.5,0}
local color_white = {1,1,1}
local color_black = {0,0,0}
local color_light_grey = {0.75,0.75,0.75}
local color_grey = {0.5,0.5,0.5}
local color_dark_grey = {0.25,0.25,0.25}
local full_trans_white = rgbm(1,1,1,1)

local _l_tmp_vec = vec2(0,0)
local _l_tmp_vec2 = vec2(0,0)



local _l_ppfileconfig_loaded_color = rgbm(1,1,0,1)
local _l_ppfileconfig_file_color = rgbm(0.75,0.75,0.75,1)
function customfunc_ppfilter_related_file(custom)
    local x = ui.getCursorX()
    ui.pushStyleColor(ui.StyleColor.Text, _l_ppfileconfig_loaded_color)
    ui.text("PPFilter related config file was loaded!")
    ui.popStyleColor(1)
    ui.setCursorX(x)
    ui.pushStyleColor(ui.StyleColor.Text, _l_ppfileconfig_file_color)
    ui.text(custom.ppfilter_related_file)
    ui.popStyleColor(1)
end


function customfunc_2dclouds_set_init(custom)

    if custom then

        local _l_skydome_sets_path = ac.getFolder(ac.FolderID.ExtRoot).."\\config-ext\\Pure\\Skydome_sets\\"
        custom.sets = {}

        io.scanDir(_l_skydome_sets_path, "*", function(name, attrib)
            if attrib.isDirectory then
                if file_exists(_l_skydome_sets_path..name.."\\skydome_script.lua") then
                    table.insert(custom.sets, name)
                end
            end
        end)

        custom.h = #custom.sets * 30

        custom.selected = ""
    end
end

function customfunc_2dclouds_set_render(custom)

    if custom then
        local x = ui.getCursorX()

        custom.selected = custom:getConnectValue(true)
        
        local new = nil
        for i=1, #custom.sets do
            ui.setCursorX(x)
            if ui.radioButton(custom.sets[i], (custom.selected == custom.sets[i])) then 
                custom.selected = custom.sets[i]
                new = custom.selected
            end
        end

        return new
    end

    return nil
end


local _l_current_tonemapping = -1
local _l_current_customPP = nil
function customfunc_tonemapping_group_render(group)
    local tmp = pure_WFX_STATE:getValue("PP.tonemapping")
    local tmp2 = pure_WFX_STATE:getValue("PP.customPP")
    if _l_current_tonemapping ~= tmp or _l_current_customPP ~= tmp2 then
        _l_current_tonemapping = tmp
        _l_current_customPP = tmp2
        if group then
            group.page.ui:resetDesign()
        end
    end
end


weather_params = {
    -- name                   id 
    { "Light Thunderstorm"  ,  0  },               
    { "Thunderstorm"        ,  1  },           
    { "Heavy Thunderstorm"  ,  2  },               
    { "Light Drizzle"       ,  3  },           
    { "Drizzle"             ,  4  },       
    { "Heavy Drizzle"       ,  5  },           
    { "Light Rain"          ,  6  },       
    { "Rain"                ,  7  },   
    { "Heavy Rain"          ,  8  },
    { "Light Snow"          ,  9  },       
    { "Snow"                , 10  },   
    { "Heavy Snow"          , 11  },       
    { "Light Sleet"         , 12  },           
    { "Sleet"               , 13  },   
    { "Heavy Sleet"         , 14  },           
    { "Clear"               , 15  },   
    { "Few Clouds"          , 16  },       
    { "Scattered Clouds"    , 17  },               
    { "Broken Clouds"       , 18  },           
    { "Overcast Clouds"     , 19  },               
    { "Fog"                 , 20  },   
    { "Mist"                , 21  },   
    { "Smoke"               , 22  },   
    { "Haze"                , 23  },   
    { "Sand"                , 24  },   
    { "Dust"                , 25  },   
    { "Squalls"             , 26  },       
    { "Tornado"             , 27  },       
    { "Hurricane"           , 28  },       
    { "Cold"                , 29  },   
    { "Hot"                 , 30  },   
    { "Windy"               , 31  },   
    { "Hail"                , 32  },   
    { "No Clouds"           ,100  }, 
    { "Random"              , 40  },
    { "Random Rainy"        , 41  },
    { "Random Bad"          , 42  },
    { "Empty"               ,666  },
    { "CM"                  , 50  },
}

local weather_params_names_list = {}
for i=1, #weather_params do
    weather_params_names_list[weather_params[i][2]] = weather_params[i][1]
end

function customfunc_weather_id_converter(value)
    if value and weather_params_names_list[value] then
        return weather_params_names_list[value]
    end
    return ""
end



gCustomScriptDirty_state = false
function customfunc_custom_script_set_dirty(dirty)
    gCustomScriptDirty_state = dirty
end

local _l_c_dirty = rgbm(0.5,0.45,0.2,1)
function customfunc_custom_script_save_button_render(button)

    local background = false
    if gCustomScriptDirty_state then
        background = true
        ui.pushStyleColor(ui.StyleColor.Button, _l_c_dirty)
    else
    end  
    PureUI_Element:render(function() 
        if ui.button(button.name, button.size, 0) then
            button:handle()
        end
    end)
    if background then ui.popStyleColor(1) end
end

function customfunc_custom_fake_dirty(dirty)
end









-- PP settings checklist

local tmp_pp_color_error = rgbm(1,0,0,1)
local tmp_pp_color_warning = rgbm(1,0.5,0,1)


local _l_pp_errors = 0
local _l_pp_errors_height = 0
local _l_pp_vignette = 0
local _l_pp_godray_diff_ring = 0
function customfunc_init_pp_errors(custom)
    
    custom.backup = RAMBackup("UI_CUSTOM_"..custom.name)
    custom.backup:BackupWithSet(true)
    _l_pp_errors = custom.backup:get("num_errors", __RAM__BACKUP__TYPES.NUMBER) or 0
    _l_pp_errors_height = custom.backup:get("errors_height", __RAM__BACKUP__TYPES.NUMBER) or 0
    custom.h = _l_pp_errors_height

    local filter = ac.getPpFilter()
    if filter==nil or filter=="" then
        -- if the ac.getPpFilter does not retrieve the name, try to use the script name
        if pure_WFX_STATE and pure_WFX_STATE:isConnected() then
            local script = pure_WFX_STATE:getString("PP.script")
            filter = string.sub(script, 1, #script-4) -- cut ".lua"
        end
    end
    local filter_file = ac.getFolder(ac.FolderID.PPFilters)
    if filter~=nil and filter~="" and filter_file~=nil then
        filter_file = filter_file.."\\"..filter..".ini"
        local ppfilter = ac.INIConfig.load(filter_file, ac.INIFormat.Default)
        _l_pp_vignette          = ppfilter:get("VIGNETTING","STRENGTH", _l_pp_vignette)
        _l_pp_godray_diff_ring  = ppfilter:get("GODRAYS","DIFFRACTION_RING", _l_pp_godray_diff_ring)
    end
end

function customfunc_render_pp_errors(custom)

    local errors = 0

    local x = ui.getCursorX()
    local y = ui.getCursorY()

   
    if _l_pp_errors > 0 then
        ui.pushFont(ui.Font.Title)
        ui.pushStyleColor(ui.StyleColor.Text, tmp_pp_color_warning)
        ui.text("PP Warnings & Errors")
        ui.popStyleColor()
        ui.popFont()
        y = y + 35
    end

    
    ui.setCursorX(15)
    ui.setCursorY(y)
    if pure_WFX_STATE and pure_WFX_STATE:isConnected() then
        local pp = pure_WFX_STATE:getValue("PP.tonemapping")
        local customPP = pure_WFX_STATE:getValue("PP.customPP")
        if pp~=nil and pp > 6 and not customPP then
            if _l_pp_vignette < 0.0000000001 then
                ui.pushStyleColor(ui.StyleColor.Text, tmp_pp_color_error)
                ui.text("YEBIS Vignette strength must not be 0!")
                ui.popStyleColor()
                ui.setCursorX(15)
                ui.text("Set it to 0.001 minimum, then custom tonemapping will work properly.")
                y = y + 50
                errors = errors + 1
            end
        end
    end


    ui.setCursorX(15)
    ui.setCursorY(y)
    
    if _l_pp_godray_diff_ring < 0.001 then
        ui.pushStyleColor(ui.StyleColor.Text, tmp_pp_color_warning)
        ui.text("YEBIS Godrays/DIFFRACTION_RING must not be 0!")
        ui.popStyleColor()
        ui.setCursorX(15)
        ui.text("Set it to 0.001 minimum, otherwise a ghost picture will appear while sunset.")
        y = y + 50
        errors = errors + 1
    end


    local new_height = (errors>0 and y or 0)
    if math.abs(errors-_l_pp_errors) >= 1 or math.abs(new_height-_l_pp_errors_height) >= 1 then
        custom.backup:set("num_errors", errors)
        custom.backup:set("errors_height", new_height)
        custom.page.ui:resetDesign()
    end
end














-- render for shader groups
local _l_group_color_active = rgb(0.25,1.00,0.25)
local _l_group_color_inactive = rgb(0.6,0.6,0.6)
local _l_group_color_error = rgb(1,0.2,0.2)
local _l_group_color_tmp = rgb(0,0,0)
function customfunc_render_shader_groups(group)

    if group and group.members then

        local e = group.members[1]
        if e.type~=PURE_UI_TYPES.CHECKBOX then
            -- check if there is an info at first position
            e=group.members[2]
        end
        if e then
            if e and e.type == PURE_UI_TYPES.CHECKBOX then

                local connect = e.page.ui.connect
                if connect then
                    local value = connect:getByName(e.name)

                    if value ~= nil then
                        if value then

                            local error = false
                            for i=2, #group.members do
                                e = group.members[i]
                                if e~=nil then
                                    if e.type==PURE_UI_TYPES.NOTDEF and e.name == ("shaders."..group.name..".error") then
                                        error = e.value or false
                                        break
                                    end
                                end
                            end

                            if error then
                                local osc = (math.sin(os.clock()*6)+1)*0.5
                                _l_group_color_tmp.r = osc * _l_group_color_error.r
                                group.background_color:set(_l_group_color_tmp)
                            else

                                group.background_color:set(_l_group_color_active)
                            end
                        else
                            group.background_color:set(_l_group_color_inactive)
                        end
                    end
                end
            end
        end
    end
end










gCustomTrackDirty_state = false
function customfunc_track_set_dirty(dirty)
    gCustomTrackDirty_state = dirty
end

local _l_c_dirty = rgbm(0.5,0.45,0.2,1)
function customfunc_track_save_custom_button_render(button)

    local background = false
    if gCustomTrackDirty_state then
        background = true
        ui.pushStyleColor(ui.StyleColor.Button, _l_c_dirty)
    else
    end  
    PureUI_Element:render(function() 
        if ui.button(button.name, button.size, 0) then
            button:handle()
        end
    end)
    if background then ui.popStyleColor(1) end
end



function customfunc_landscape_files_init(custom)

    if custom then

        local _l_path = ac.getFolder(ac.FolderID.ExtRoot).."\\weather\\pure\\render\\landscape\\textures\\"
        custom.files = {}

        io.scanDir(_l_path, "*.dds", function(name, attrib)
            if not attrib.isDirectory then
                name = name:gsub("%.dds", "")
                table.insert(custom.files, name)
            end
        end)

        custom.h = 30

        custom.selected = ""
    end
end

function customfunc_landscape_files_render(custom)

    if custom and not custom.hidden then
        
        custom.selected = custom:getConnectValue(true)
        
        local new = nil
        
        ui.setCursorX(custom.x+9)
        ui.setCursorY(custom.y)
        ui.combo("LANDSCAPE_FILES", custom.selected, function() 
            for i=1, #custom.files do
                if ui.selectable(custom.files[i], custom.selected==custom.files[i]) then
                    custom.selected = custom.files[i]
                    new = custom.selected
                end
            end
        end)
    
        
        return new
    end

    return nil
end

function customfunc_ta_clipboard_internal(button)
    if button then
        local e
        if ui.mouseDown(ui.MouseButton.Right) then
            e = { section="TRACKexportConfigClipboard__INTERNAL" }
        else
            e = { section="TRACKexportConfigClipboard" }
        end
        button.page.ui.handleButton(e)
    end
end





local rgb_grey = rgb(0.5,0.5,0.5)
local rgb_dark_grey = rgb(0.25,0.25,0.25)
local rgb_dark_orange = rgb(0.50,0.35,0.0)
local rgb_dark_green = rgb(0,0.5,0)

local function custom_dirty_headlights_check(e, condition)
    if condition then
        if PURE_CONFIG__replay_active() then
            e.colorBack = rgb_dark_orange
        else
            e.colorBack = rgb_dark_green
        end
    else
        e.colorBack = rgb_dark_grey
    end
end

local function custom_dirty_high_beams_check(e, condition)
    if condition then
        e.colorBack = rgb_dark_green
    else
        e.colorBack = rgb_dark_grey
    end
end




local quality_setting = 0
function PURE_CONFIG__set_quality_setting(n)
    quality_setting = n
end
local _l_quali_button = 1
local function custominit_quality_buttons(custom)
    custom.quality_number = _l_quali_button
    _l_quali_button = _l_quali_button + 1
end
local _l_tmp_button_color = rgb(0,0,0)
local _l_tmp_button_color_rgbm = rgbm(0,0,0,1)
local function customfunc_quality_buttons(button)
    if button then
        
        local styles = 0
        if button.colorBack then
            ui.pushStyleColor(ui.StyleColor.Button, button.colorBack)
            
            _l_tmp_button_color_rgbm.r = button.colorBack.r * 1.5
            _l_tmp_button_color_rgbm.g = button.colorBack.g * 1.5
            _l_tmp_button_color_rgbm.b = button.colorBack.b * 1.5
            ui.pushStyleColor(ui.StyleColor.ButtonHovered, _l_tmp_button_color_rgbm)
            styles = styles + 2
        end
        if button.colorText then 
            ui.pushStyleColor(ui.StyleColor.Text, button.colorText)
            styles = styles + 1
        end
        PureUI_Element:render(function()
            if button.quality_number == quality_setting then
                _l_tmp_button_color.r = button.colorBack.r * 2
                _l_tmp_button_color.g = button.colorBack.g * 2
                _l_tmp_button_color.b = button.colorBack.b * 2

                UI_gl_rect(ui.getCursorX()-2, ui.getCursorY()-2, ui.getCursorX()+button.size.x+1, ui.getCursorY()+button.size.y+1, _l_tmp_button_color, 3)
            end
            if ui.button(button.name, button.size, 0) then
                button:handle()
            end
        end)
        if styles>0 then 
            ui.popStyleColor(styles)
        end
    end
end






local _l_strobo_image = __pureConfig_path.."\\UI\\assets\\strobo.png"
local function shader__strobo_render_func(custom)

    if custom then
        
        local x = custom.x + 10
        local y = custom.y

        local select = custom.customConnect:getByName("consent.stroboscopic_selection")

        local color = rgb.colors.green
        if select < 1 then
            color = rgb.colors.cyan
        elseif select > 1 then
            color = rgb.colors.yellow
        end

        _l_tmp_vec:set(x,y)
        _l_tmp_vec2:set(ui.availableSpaceX() + 35, y + custom.h - 5)
        ui.drawRectFilled(_l_tmp_vec, _l_tmp_vec2, color)


        local pic_width = 50
        local zoom = pic_width/300
        _l_tmp_vec:set(300*zoom, 266*zoom)

        ui.setCursorX(x + 5)
        ui.setCursorY(y + 5)
        ui.image(_l_strobo_image, _l_tmp_vec, full_trans_white)

        local w = ui.availableSpaceX() - 70
        local wh = w*0.5
        local h = custom.h
        x = 70 + wh

        ui.setCursorY(y + 5)
        if select < 1 then
            ui.setCursorX(x - 70)
            ui.text("Switched off completely")
        elseif select > 1 then
            ui.pushStyleColor(ui.StyleColor.Text, rgb.colors.black)
            ui.setCursorX(x - 98)
            ui.text("Activated with full flashing effects")
            ui.popStyleColor(1)
        else
            ui.setCursorX(x - 96)
            ui.text("Activated, but no flashing effects")
        end
        

        ui.setCursorX(x - 100)
        ui.setCursorY(y + 25)
        _l_tmp_vec:set(200, 25)
        if ui.button("Reset stroboscopic consent", _l_tmp_vec) then

            custom.customConnect:init(custom.connect_id+1, false)

            local connect = custom.page.ui:getConnect()
            connect:addCommand("RootSave")
            connect:addCommand("resetPure")
        end
--[[

        

        

        local connect = custom.page.ui:getConnect()
        if connect then

            if selected < 1 then
                connect:init(connect:getIDByName("shaders.lightning.active")+1, false)
            elseif selected < 2 then
                connect:init(connect:getIDByName("shaders.lightning.speed")+1, 0.25)
            elseif selected > 1 then
                connect:init(connect:getIDByName("shaders.lightning.speed")+1, 0.90)
            end

            connect:addCommand("RootSave")
            connect:addCommand("SaveUserConfig")
            connect:addCommand("resetPure")
        end
]]

    end
end




local wrong_settings = false
local function wrong_settings_design(page, lcs)

    lcs = lcs or false
    
    page:newTextBlock(nil, nil, "Pure Checklist:")


    if PureConfig_get_RefFreq() > 0 then
        --page:newText(nil, nil, "Reflections frequency is not set to static.", {text_color=color_green} )
    else
        page:newText(nil, nil, "Reflections frequency is set to static!", {text_color=color_red} )
        page:newText(nil, nil, "> Change reflections frequency to minimum \"One face per frame\"" )
        page:newText(nil, nil, "> Settings -> Assetto Corsa -> Video -> Reflections" )
        wrong_settings = true
    end

    if PureConfig_get_RefFX() > 0 then
        --page:newText(nil, nil, "ReflectionsFX is enabled.", {text_color=color_green} )
    else
        page:newText(nil, nil, "ReflectionsFX is deactivated!", {text_color=color_red} )
        page:newText(nil, nil, "> Activate ReflectionsFX !" )
        page:newText(nil, nil, "> Settings -> Custom Shaders Patch -> REFLECTIONS FX" )
        wrong_settings = true
    end
    
    if PureConfig_get_RefIBL() > 0 then
        --page:newText(nil, nil, "ReflectionsFX is using proper physically-based sampling.", {text_color=color_green} )
    else
        page:newText(nil, nil, "ReflectionsFX is NOT using proper physically-based sampling.", {text_color=color_orange} )
        page:newText(nil, nil, "> Activate \"Use proper physically-based sampling\"." )
        page:newText(nil, nil, "> Settings -> Custom Shaders Patch -> REFLECTIONS FX" )
        page:newText(nil, nil, "> -> General Cubemap Reflections" )
        wrong_settings = true
    end

    if PureConfig_get_RefCarCubemap() > 0 then
        page:newText(nil, nil, "ReflectionsFX-Tweak \"Cubemap around car\" is used", {text_color=color_red} )
        page:newText(nil, nil, "> Deactivate \"Shot cubemap around focused car rather than camera\"!" )
        page:newText(nil, nil, "> Settings -> Custom Shaders Patch -> REFLECTIONS FX" )
        page:newText(nil, nil, "> -> Tweaks" )
        wrong_settings = true
    end

    if PureConfig_get_ParticlesFX() < 1 then
        page:newText(nil, nil, "ParticlesFX is deactivated. You need it for Pure's shaders!", {text_color=color_orange} )
        page:newText(nil, nil, "> Activate ParticlesFX !" )
        page:newText(nil, nil, "> Settings -> Custom Shaders Patch -> PARTICLES FX" )
        wrong_settings = true
    end

    if PureConfig_get_ClipPlanes() < 1 then
        page:newText(nil, nil, "Adaptive clip planes are deactivated or have wrongs settings.", {text_color=color_orange} )
        page:newText(nil, nil, "You need proper adaptive clip planes!", {text_color=color_orange} )
        page:newText(nil, nil, "> Press \"Try to fix wrong settings!\"" )
        wrong_settings = true
    end

    if PureConfig_get_ConfigChanges() < 1 then
        page:newText(nil, nil, "Watching config changes is deactivated!", {text_color=color_red} )
        page:newText(nil, nil, "> Activate \"Watch configs for changes\"." )
        page:newText(nil, nil, "> Settings -> Custom Shaders Patch -> General Patch Settings" )
        page:newText(nil, nil, "> -> System Settings" )
        page:newText(nil, nil, "> Restart AC" )
        wrong_settings = true
    end

    if PureConfig_get_WfxExtraEffects() < 1 then
        page:newText(nil, nil, "WeatherFX extra effects are deactivated!", {text_color=color_orange} )
        page:newText(nil, nil, "> Pure shaders will not work then!" )
        page:newText(nil, nil, "> Activate \"Extra visual effects\"." )
        page:newText(nil, nil, "> Settings -> Custom Shaders Patch -> WeatherFX" )
        page:newText(nil, nil, "> -> Performance" )
        wrong_settings = true
    end

    if PURE_CONFIG__get_YEBISSEST() < 1 then
        page:newText(nil, nil, "The obsolete CSP modul \"Yebisest\" is set wrong", {text_color=color_orange} )
        wrong_settings = true
    end

    if PureConfig_get_SoundSettings() then
        page:newText(nil, nil, "Sound settings are wrong", {text_color=color_red} )
        page:newText(nil, nil, "> Reset your settings in:" )
        page:newText(nil, nil, "> Settings -> Custom Shaders Patch")
        page:newText(nil, nil, "> General Patch settings -> Audio" )
        wrong_settings = true
    end

--[[
    if PureConfig_get_FXAA31() then
        page:newText(nil, nil, "FXAA 3.1 is used!", {text_color=color_orange} )
        page:newText(nil, nil, "> This PP AA method probably causes problems!" )
        page:newText(nil, nil, "> Choose a different \"Post-processing antialiasing\"!" )
        page:newText(nil, nil, "> Settings -> Custom Shaders Patch -> Graphics Adjustments" )
        page:newText(nil, nil, "> -> Post-processing antialiasing" )
        wrong_settings = true
    end
]]

    -- HDR check
    local _l_CSP_MODUL = ac.INIConfig.cspModule(ac.CSPModuleID.DXGITweaks)
    local value = _l_CSP_MODUL:get("HDR","ENABLED", 0)
    _l_CSP_MODUL = ac.INIConfig.cspModule(ac.CSPModuleID.GraphicsAdjustments)
    local value2 = _l_CSP_MODUL:get("ANTIALIASING","FFXCAS_PASS", 0)
    if lcs and value > 0 and value2 > 0 then
        page:newText(nil, nil, "\"Use FidelityFX CAS by AMD for extra sharpness\"", {text_color=color_orange} )
        page:newText(nil, nil, "is currently not working in HDR!", {text_color=color_orange} )
        wrong_settings = true

        page:newButton("fixHDR_FidelityFX", "", "Set correct HDR settings", {
            background_color={0.5,0.25,0.0},
            custom_handle = function(e)
                _l_CSP_MODUL = ac.INIConfig.cspModule(ac.CSPModuleID.GraphicsAdjustments)
                _l_CSP_MODUL:setAndSave("ANTIALIASING","FFXCAS_PASS", 0)
                --page.ui:resetDesign() watcher already exists and will reset the design
            end
        })
    end

    if wrong_settings then
        page:newButton("fixWrongSettings", "", "Try to fix wrong settings", { background_color={0.5,0.0,0.0} })
    else
        page:newText(nil, nil, "✅ CSP settings seem to be correct", {text_color=color_green} )
    end
end


local function recommended_settings_design(page, lcs)

    lcs = lcs or false

    page:newTextBlock(nil, nil, "Recommended CSP settings", {text_color=color_light_grey} )

    local found = false

    --[[
    -- shadows
    _l_CSP_MODUL = ac.INIConfig.cspModule(ac.CSPModuleID.SmartShadows)
    local auto_split = _l_CSP_MODUL:get("BASIC","AUTOMATIC_SPLITS", 1)
    if auto_split > 0 then
        page:newText(nil, nil, "Automatic splits are active in Smart Shadows settings.", {text_color=color_yellow} )
        page:newText(nil, nil, "Shadows appearance can fluctuate much with this setting,", {text_color=color_white} )
        page:newText(nil, nil, "esp. with lower Sun angles. The recommended shadows settings", {text_color=color_white} )
        page:newText(nil, nil, "are not necessary, it's just a suggestion for steadier shadows.", {text_color=color_white} )

        page:newButton("set_recommended_shadow_setting", "", "Set recommended Smart Shadows settings", {
            background_color={0.0,0.35,0.5},
            custom_handle = function(e)
                _l_CSP_MODUL = ac.INIConfig.cspModule(ac.CSPModuleID.SmartShadows)
                _l_CSP_MODUL:set("BASIC", "INTERIOR_SPLIT", {"5", "100", "500"})
                _l_CSP_MODUL:set("BASIC", "EXTERIOR_SPLIT", {"40", "150", "1000"})
                _l_CSP_MODUL:set("CUSTOM_SHADOW_MATRICES", "FOURTH_CASCADE_DISTANCE", 2000)
                _l_CSP_MODUL:set("CUSTOM_SHADOW_MATRICES", "LOOKLESS", 1)
                _l_CSP_MODUL:save()
                _l_CSP_MODUL:setAndSave("BASIC","AUTOMATIC_SPLITS", 0)
                --page.ui:resetDesign() watcher already exists and will reset the design
            end
        })

        found = true
    end
    ]]

    if not found then
        page:newText(nil, nil, "The settings seem to be good.", {text_color=color_grey} )
    end
end


































local function createPureConfigUI__ok(PureUIobj)
--[[
    for k,v in pairs(ui) do
        --if type(v) == "function" then
            ac.debug("ui."..k, v)
        --end
    end
]]

    local page, h, item, h_e, tabbar, group
    local connect = PureUIobj:getConnect()

    local root_config_connect = PureConfig_getConnectConfigRoot()

    local eco = pure_WFX_STATE:getValue("settings.eco")

    -- ###############
    -- # MAIN 
    -- ###############
    page = PureUIobj:newPage("Main")

    local _l_clouds_render_method = PureUIobj.connect:getByName("clouds_render.method", false)


    if eco then
        page:newTextBlock(nil, nil, "Pure runs in economic mode...")
    else

        page:newTextBlock(nil, nil, "Quality Presets")

        _l_quali_button = 1 --set this variable to 1, it will raised by the buttons custom init function
        h = page:getHPos()
        h_e = 30
        item = page:newButton("qualityLOW", nil, "Low", {size={80,h_e},
                                                        position={3,h},
                                                        background_color={0.1,0.2,0.4},
                                                        custom_init = custominit_quality_buttons,
                                                        custom_render = customfunc_quality_buttons})
        local txt_groundfog = "Groundfog OFF"
        item:setTooltip(
            (_l_clouds_render_method > 0) and
                txt_groundfog
            or
                "Low 3D Clouds quality\n\n"..txt_groundfog
        )

        item = page:newButton("qualityMEDIUM", nil, "Medium", {size={80,h_e},
                                                        position={88,h},
                                                        background_color={0.2,0.4,0.1},
                                                        custom_init = custominit_quality_buttons,
                                                        custom_render = customfunc_quality_buttons})
        txt_groundfog = "Groundfog:\n✅ quality\n🟠 render distance\n❌ Car turbulences"
        item:setTooltip(
            (_l_clouds_render_method > 0) and
                txt_groundfog
            or
                "Medium 3D Clouds quality\n\n"..txt_groundfog
        )
        

        item = page:newButton("qualityHIGH", nil, "High", {size={80,h_e},
                                                        position={173,h},
                                                        background_color={0.4,0.3,0.1},
                                                        custom_init = custominit_quality_buttons,
                                                        custom_render = customfunc_quality_buttons})
        txt_groundfog = "Groundfog:\n✅ quality\n✅ render distance\n❌ Car turbulences"
        item:setTooltip(
            (_l_clouds_render_method > 0) and
                txt_groundfog
            or
                "High 3D Clouds quality\n\n"..txt_groundfog
        )

        item = page:newButton("qualityVERYHIGH", nil, "Very High", {size={80,h_e},
                                                        position={258,h},
                                                        background_color={0.4,0.1,0.1},
                                                        custom_init = custominit_quality_buttons,
                                                        custom_render = customfunc_quality_buttons})
        txt_groundfog = "Groundfog:\n✅ quality\n✅ render distance\n✅ Car turbulences"
        item:setTooltip(
            (_l_clouds_render_method > 0) and
                txt_groundfog
            or
                "Very high 3D Clouds quality\n\n"..txt_groundfog
        )
        
        page:shiftHPos(h_e + 20)
    end



    

    wrong_settings = false
    wrong_settings_design(page, false)

    page:newSeparator()
    recommended_settings_design(page, false)


    -- check for clouds_render method and csp version
    if connect and connect:isConnected() then
        local clouds = connect:getByName("clouds_render.method") or 0
        if clouds > 0 and __CSP_version < 1992 then
            -- CSP lower 1.77 and 2dclouds
            page:newText(nil, nil, "You need at least CSP 1.78 for skydomes!", {text_color=color_red} )
        end
    end

    if pure_WFX_STATE and pure_WFX_STATE:isConnected() then

        local missing_skydome_textures = pure_WFX_STATE:getValue("clouds2D.missing_textures")
        if missing_skydome_textures > 0 then
            page:newText(nil, nil, tostring(missing_skydome_textures).." Skydome texture"..(missing_skydome_textures>1 and "s are" or " is").." missing!", {text_color=color_orange} )
        end
--[[
        -- Check which ppfilter script is loaded
        if PureConfig_PPactivated() then
            local script = pure_WFX_STATE:getString("PP.script")
            if script == "default_script.lua" then
                page:newText(nil, nil, "The current PP-filter has no Pure Script!", {text_color=color_orange} )
                page:newText(nil, nil, "The PP-filter may not function correctly with Pure!", {text_color=color_orange} )
            end
        end
]]
    end

    page:shiftHPos(10)

    page:newSeparator()
    page:newButton("resetPure", "", "Restart weatherFX system...")


    page:shiftHPos(10)

    page:newSeparator()
    page:newText(nil, nil, "Reset the Pure config to default values.")
    page:newText(nil, nil, "The config is not yet saved after this reset!")
    page:newText(nil, nil, "You can still load your settings again.")
    page:newButton("resetToDefaults", "", "Reset To Defaults")

    page:shiftHPos(10)

    page:newSeparator()

    local file = pure_WFX_STATE:getString("config.ppfilterrelatedfile")
    if file~=nil and file~="" then
        item = page:newCustom(nil,nil,nil,"ppfilter_related_file", {custom_render = customfunc_ppfilter_related_file, size={-1, 50}})
        item.ppfilter_related_file = string.gsub(file, ac.getFolder(ac.FolderID.Root), "")
    end

    -- show config separation toogle
    page:newText(nil, nil, "Use multiple Pure configs for different video modes (VR + ppOff)." )
    item = page:AutoCreateFromConnectName("config.video_mode_separation", { customConnect = root_config_connect,
                                                                            custom_handle = function(obj) obj.customConnect:addCommand("RootSave") end
                                                                          })
    
    page:newStateString(nil,nil,"Current Config Video Mode", "config.usedfile")

    page:shiftHPos(10)


    page:newSeparator()


    -- track specific loading
    if file == nil or file=="" then
        -- don't show it, if ppfilter related files are used

        page:newText(nil, nil, "Automatically load track specific config, if available." )
        item = page:AutoCreateFromConnectName("config.track_specific_loading", { customConnect = root_config_connect,
                                                                                custom_handle = function(obj) obj.customConnect:addCommand("RootSave") end
                                                                            })
        item:setTooltip("Automatic loading of the track specific config file at AC start.")

        item = page:AutoCreateFromConnectName("config.track_specific_video_separation", { customConnect = root_config_connect,
                                                                            custom_handle = function(obj) obj.customConnect:addCommand("RootSave") end
                                                                            })
        item:setTooltip("Creating track specific config files per video mode (default, VR or PP off)")
        
        local track_config = pure_WFX_STATE:getString("config.usedtrackfile")
        if track_config~=nil and track_config~="" then
            page:newStateString(nil,nil,"file", "config.usedtrackfile")

            item = page:newButton("saveTrackSpecific", "", "Save track specific config", {size={200, nil}, background_color={0.1,0.4,0.1}})
            item:setTooltip("Save a track specific config")
            item = page:newButton("loadTrackSpecific", "", "Load track specific config", {size={200, nil}, background_color={0.1,0.3,0.4}})
            item:setTooltip("Load the track specific config")
            item = page:newButton("deleteTrackSpecific", "", "Delete track specific config", {size={200, nil}, background_color={0.4,0.1,0.1}})
            item:setTooltip("Delete the track specific config")
        else
            page:newText(nil, nil, "The default Pure Gamma config is used with this track.", {text_color={0.5,0.5,0.5}})

            item = page:newButton("saveTrackSpecific", "", "Save track specific config", {size={200, nil}, background_color={0.1,0.4,0.1}})
            item:setTooltip("Save a track specific config")
        end
    else
        page:newText(nil, nil, "A ppfilter related config is loaded.\nTrack specific loading of configs is deactivated.", {text_color={0.5,0.5,0.5}})
    end









    -- ###############
    -- # AI
    -- ###############

    page = PureUIobj:newPage("AI")

    page:newStateValue(nil,nil,"Sun angle", "stellar.sun.angle")
    item = page:AutoCreateFromConnectName("AI_headlights.sun")
    item:setTooltip("If the altidute of the sun is under this value, headlights will be switched on.")
    
    page:newStateValue(nil,nil,"Ambient Luminance", "ambient.luminance")
    item = page:AutoCreateFromConnectName("AI_headlights.ambient_light")
    item:setTooltip("If ambient luminance is under this value, headlights will be switched on.")

    page:newStateValue(nil,nil,"Cubemap Brightness Estimation", "cbe.average")
    item = page:AutoCreateFromConnectName("AI_headlights.CBE")
    item:setTooltip("If CBE is under this value, headlights will be switched on.")

    page:newStateValue(nil,nil,"Fog Dense", "fog.dense")
    item = page:AutoCreateFromConnectName("AI_headlights.fog")
    item:setTooltip("If fog is over this value, headlights will be switched on.")

    page:newStateValue(nil,nil,"Rain Intensity", "rain.intensity")
    item = page:AutoCreateFromConnectName("AI_headlights.rain")
    item.power = 3
    item:setTooltip("If rain intensity is over this value, headlights will be switched on.")

    page:shiftHPos(10)

    if PURE_CONFIG__get_HeadlightsControl() then
        
        page:newTextBlock(nil,nil, "Headlights and high beams control")
        page:newText(nil,nil, "If set to Pure, the lights are strictly controlled by Pure!", {text_color = {0.5,0.5,0.5}})
        page:newText(nil,nil, "If set to Default, the lights are controlled by CSP (automatic or player control),", {text_color = {0.5,0.5,0.5}})
        page:newText(nil,nil, "except in replays, then Pure will control it.", {text_color = {0.5,0.5,0.5}})
        page:newText(nil,nil, "High beams are not controlled by Pure.", {text_color = {0.5,0.5,0.5}})

        page:shiftHPos(10)
        h = page:getHPos()

        local tmp_headlights = connect:getByName("AI_headlights.headlights_ctrl")
        if tmp_headlights~=nil then
            PURE_CONFIG__set_cars_headlights(tmp_headlights)
        end
        tmp_headlights = connect:getByName("AI_headlights.high_beams_ctrl")
        if tmp_headlights~=nil then
            PURE_CONFIG__set_cars_high_beams(tmp_headlights)
        end

        page:newButton(nil,nil, "Headlights Pure", {
            custom_dirty=function(e)
                custom_dirty_high_beams_check(e, PURE_CONFIG__get_cars_headlights()==100)
            end,
            custom_handle=function(e)
                PURE_CONFIG__set_cars_headlights(100)
            end,
            position={0, h},
            size={150, 30},
        })

        page:newButton(nil,nil, "Headlights Default", {
            custom_dirty=function(e)
                custom_dirty_headlights_check(e, PURE_CONFIG__get_cars_headlights()==ac.SceneTweakFlag.Default)
            end,
            custom_handle=function(e)
                PURE_CONFIG__set_cars_headlights(ac.SceneTweakFlag.Default)
            end,
            position={0, h + 35},
            size={150, 30},
        })

        page:newButton(nil,nil, "Headlights Force On", {
            custom_dirty=function(e)
                custom_dirty_high_beams_check(e, PURE_CONFIG__get_cars_headlights()==ac.SceneTweakFlag.ForceOn)
            end,
            custom_handle=function(e)
                PURE_CONFIG__set_cars_headlights(ac.SceneTweakFlag.ForceOn)
            end,
            position={0, h + 70},
            size={150, 30},
        })

        page:newButton(nil,nil, "Headlights Force Off", {
            custom_dirty=function(e)
                custom_dirty_high_beams_check(e, PURE_CONFIG__get_cars_headlights()==ac.SceneTweakFlag.ForceOff)
            end,
            custom_handle=function(e)
                PURE_CONFIG__set_cars_headlights(ac.SceneTweakFlag.ForceOff)
            end,
            position={0, h + 105},
            size={150, 30},
        })


        page:newButton(nil,nil, "High Beams Default", {
            custom_dirty=function(e)
                custom_dirty_high_beams_check(e, PURE_CONFIG__get_cars_high_beams()==ac.SceneTweakFlag.Default)
            end,
            custom_handle=function(e)
                PURE_CONFIG__set_cars_high_beams(ac.SceneTweakFlag.Default)
            end,
            position={170, h + 35},
            size={150, 30},
        })

        page:newButton(nil,nil, "High Beams Force On", {
            custom_dirty=function(e)
                custom_dirty_high_beams_check(e, PURE_CONFIG__get_cars_high_beams()==ac.SceneTweakFlag.ForceOn)
            end,
            custom_handle=function(e)
                PURE_CONFIG__set_cars_high_beams(ac.SceneTweakFlag.ForceOn)
            end,
            position={170, h + 70},
            size={150, 30},
        })

        page:newButton(nil,nil, "High Beams Force Off", {
            custom_dirty=function(e)
                custom_dirty_high_beams_check(e, PURE_CONFIG__get_cars_high_beams()==ac.SceneTweakFlag.ForceOff)
            end,
            custom_handle=function(e)
                PURE_CONFIG__set_cars_high_beams(ac.SceneTweakFlag.ForceOff)
            end,
            position={170, h + 105},
            size={150, 30},
        })

        page:newButton(nil, nil, "Deactivate Headlights control", {
            background_color={0.5,0.2,0.2},
            custom_handle = function()
                local _l_CSP_MODUL_WEATHERFX = ac.INIConfig.cspModule(ac.CSPModuleID.WeatherFX)
                _l_CSP_MODUL_WEATHERFX:setAndSave("MISCELLANEOUS","SWITCH_HEADLIGHTS_WITH_AI", 0)
                PureUIobj:resetDesign()
            end,
            position={0, h + 150},
            size={320, 30},
        })
    else
        page:newTextBlock(nil,nil, "To control headlights, \"Turn headlights on and off automatically\"")
        page:newText(nil,nil, "must be activated in:")
        page:newText(nil,nil, "Content Manager")
        page:newText(nil,nil, "\t->SETTINGS")
        page:newText(nil,nil, "\t\t->Custom Shaders Patch")
        page:newText(nil,nil, "\t\t\t->WeatherFX")
        page:newButton(nil, nil, "Activate Headlights control", {
            background_color={0.2,0.5,0.2},
            custom_handle = function()
                local _l_CSP_MODUL_WEATHERFX = ac.INIConfig.cspModule(ac.CSPModuleID.WeatherFX)
                _l_CSP_MODUL_WEATHERFX:setAndSave("MISCELLANEOUS","SWITCH_HEADLIGHTS_WITH_AI", 1)
                PureUIobj:resetDesign()
            end
        })
    end









    -- ###############
    -- # LIGHT 
    -- ###############

    page = PureUIobj:newPage("Light")
    page:newTextBlock(nil, nil, "Daylight Multiplier")
    item = page:AutoCreateFromConnectName("light.daylight_multiplier")
    
    page:newTextBlock(nil, nil, "Sunlight")
    item = page:AutoCreateFromConnectName("light.sun.hue")
    item = page:AutoCreateFromConnectName("light.sun.saturation")
    item = page:AutoCreateFromConnectName("light.sun.level")
    item = page:AutoCreateFromConnectName("light.sun.speculars")

    page:newTextBlock(nil, nil, "Ambient Light")
    if __CSP_version>2661 then -- 0.2.1p9
        item = page:AutoCreateFromConnectName("light.ambient_model_V2")
        item:setTooltip("0: single ambient light (V1)\n1: tiled ambient light (V2)")
    end
    item = page:AutoCreateFromConnectName("light.ambient.hue")
    item = page:AutoCreateFromConnectName("light.ambient.saturation")
    item = page:AutoCreateFromConnectName("light.ambient.level")
    item = page:AutoCreateFromConnectName("light.advanced_ambient_light")
    if __CSP_version>2661 then -- 0.2.1p9
        group = page:newGroup(nil, nil, "Ambient Light V2")
        item = page:AutoCreateFromConnectName("light.advanced_ambient_lightV2_sun", { group = group })
        item = page:AutoCreateFromConnectName("light.advanced_ambient_lightV2_skydomes", { group = group })
        item = page:AutoCreateFromConnectName("light.advanced_ambient_lightV2_sky", { group = group })
        item = page:AutoCreateFromConnectName("light.advanced_ambient_lightV2_clouds", { group = group })
        item = page:AutoCreateFromConnectName("light.advanced_ambient_lightV2_nlp", { group = group })
        item = page:AutoCreateFromConnectName("light.advanced_ambient_lightV2_fog", { group = group })
        item = page:AutoCreateFromConnectName("light.advanced_ambient_light_vao_exp", { group = group })
        item:setTooltip("Exponent of the adv. ambi light VAO control")
    end

    if __CSP_version >= 2079 then
        page:newTextBlock(nil, nil, "Distant Ambient Light")
        item = page:AutoCreateFromConnectName("light.distant_ambient.hue")
        item = page:AutoCreateFromConnectName("light.distant_ambient.saturation")
        item = page:AutoCreateFromConnectName("light.distant_ambient.level")
        item = page:AutoCreateFromConnectName("light.distant_ambient.distance")
    end

    page:newTextBlock(nil, nil, "Directional Ambient Light")
    item = page:AutoCreateFromConnectName("light.directional_ambient.hue")
    item = page:AutoCreateFromConnectName("light.directional_ambient.saturation")
    item = page:AutoCreateFromConnectName("light.directional_ambient.level")
    --item = page:AutoCreateFromConnectName("light.directional_ambient.cloud_shadow_boost")

    page:newTextBlock(nil, nil, "CSP GrassFX shading")
    item = page:AutoCreateFromConnectName("light.grass_shading.specularity")
    item = page:AutoCreateFromConnectName("light.grass_shading.reflectivity")
    item = page:AutoCreateFromConnectName("light.grass_shading.backlit")
    item = page:AutoCreateFromConnectName("light.grass_shading.saturation")

    page:newTextBlock(nil, nil, "Shadows")
    item = page:AutoCreateFromConnectName("shadows.presence")

    page:newTextBlock(nil, nil, "CSP Lights")
    item = page:AutoCreateFromConnectName("csp_lights.bounce")
    item = page:AutoCreateFromConnectName("csp_lights.emissive")
    item = page:AutoCreateFromConnectName("csp_lights.displays")

    page:newTextBlock(nil, nil, "Reflections")
    item = page:AutoCreateFromConnectName("reflections.saturation")
    item = page:AutoCreateFromConnectName("reflections.level")
    item = page:AutoCreateFromConnectName("reflections.emissive_boost")
    if __CSP_version >= 3435 then -- 0.2.9
        item = page:AutoCreateFromConnectName("reflections.sky.luminance")
        item.power = 2.0
        item = page:AutoCreateFromConnectName("reflections.sky.saturation")
        item = page:AutoCreateFromConnectName("reflections.sky.gamma")
    end

    page:newTextBlock(nil, nil, "VAO")
    item = page:AutoCreateFromConnectName("vao.amount")
    item = page:AutoCreateFromConnectName("vao.track_exponent")
    item = page:AutoCreateFromConnectName("vao.dynamic_exponent")

    page:newTextBlock(nil, nil, "UI")
    item = page:AutoCreateFromConnectName("ui.white_reference_point")
    page:newStateValue(nil,nil,"White Reference Point", "ui.white_reference_point")












    -- ###############
    -- # NIGHT 
    -- ###############

    page = PureUIobj:newPage("Night")

    page:newTextBlock(nil, nil, "Night Light Pollution Multipliers")
    item = page:AutoCreateFromConnectName("nlp.level")
    item = page:AutoCreateFromConnectName("nlp.density")

    page:newSeparator()

    page:newText(nil, nil, "Night Light Pollution")
    h = page:getHPos()
    page:newText(nil, nil, "Camera Position Relevance")
    page:newStateValue(nil,nil,"", "nlp.cam_pos_relevance", {position={165,h}})
    h = page:getHPos()
    page:newText(nil, nil, "Center")
    page:newStateValue(nil,nil,"X", "nlp.center.x", {position={50,h}, unit="m"})
    page:newStateValue(nil,nil,"Y", "nlp.center.y", {position={140,h}, unit="m"})
    page:newStateValue(nil,nil,"Z", "nlp.center.z", {position={230,h}, unit="m"})
    h = page:getHPos()
    page:newText(nil, nil, "Radius")
    page:newStateValue(nil,nil,"", "nlp.radius", {position={50,h}, unit="m"})
    h = page:getHPos()
    page:newText(nil, nil, "Density")
    page:newStateValue(nil,nil,"", "nlp.density", {position={50,h}})
    h = page:getHPos()
    page:newText(nil, nil, "Color")
    page:newStateValue(nil,nil,"R", "nlp.color.r", {position={50,h}})
    page:newStateValue(nil,nil,"G", "nlp.color.g", {position={110,h}})
    page:newStateValue(nil,nil,"B", "nlp.color.b", {position={170,h}})

    page:shiftHPos(20)
    page:newTextBlock(nil, nil, "Lowest Ambient Light")
    item = page:AutoCreateFromConnectName("nlp.lowest_ambient")

    page:shiftHPos(20)
    page:newTextBlock(nil, nil, "Moon")
    item = page:AutoCreateFromConnectName("moon.no_shadows")
    item:setTooltip("Moonlight will not cast shadows (more fps)")
    item = page:AutoCreateFromConnectName("moon.light")
    item:setTooltip("Set the brightness of the moonlight.")
    item = page:AutoCreateFromConnectName("moon.appearance")
    item:setTooltip("Set the brightness of the moon appearance.")

    page:newTextBlock(nil, nil, "Stars")
    item = page:AutoCreateFromConnectName("stars.appearance")
    item:setTooltip("Set the brightness of the stars.")
    item = page:AutoCreateFromConnectName("stars.dynamic_adaption")
    item:setTooltip("If Pure's exposure calculation is used,\nthe exposure is used to improve\nthe star's light dynamics.")
    












    -- ###############
    -- # SKY 
    -- ###############

    page = PureUIobj:newPage("Sky")

    page:newTextBlock(nil, nil, "Sky Light")
    item = page:AutoCreateFromConnectName("light.sky.hue")
    item = page:AutoCreateFromConnectName("light.sky.saturation")
    item = page:AutoCreateFromConnectName("light.sky.level")

    page:newTextBlock(nil, nil, "visible Sun Disk")
    item = page:AutoCreateFromConnectName("sky.sun_disk.hue")
    item = page:AutoCreateFromConnectName("sky.sun_disk.saturation")
    item = page:AutoCreateFromConnectName("sky.sun_disk.level")


    page:newTextBlock(nil, nil, "Sun/Moon")
    item = page:AutoCreateFromConnectName("sun.sun_moon_size")









    -- ###############
    -- # CLOUDS
    -- ###############

    page = PureUIobj:newPage("Clouds")

    if not eco then

        page:newTextBlock(nil, nil, "Clouds Render Method")
        item = page:AutoCreateFromConnectName("clouds_render.method")
        item:setTooltip("0: 3D bilboard clouds / multi layer\n1: 360° Skydomes")

        

        if _l_clouds_render_method == 0 then
            -- 3D clouds
            page:newTextBlock(nil, nil, "3D clouds")
            h = page:getHPos()
            page:newStateValue(nil,nil,"Cells", "clouds.cell_count", {position={0,h}})
            page:newStateValue(nil,nil,"Subparts", "clouds.subpart_count", {position={75,h}})
            page:newStateValue(nil,nil,"AC Clouds", "clouds.ac_count", {position={180,h}})
            page:shiftHPos(20)
            page:newSeparator()
            page:AutoCreateAllFromMainCategory("clouds", false, false) 

        elseif _l_clouds_render_method == 1 then
            -- 2D clouds

            -- check for clouds_render method and csp version
            if __CSP_version < 1992 then
                -- CSP lower 1.77 and 2dclouds
                page:newText(nil, nil, "You need at least CSP 1.78 for skydomes!", {text_color=color_red} )
            else
        
                page:newTextBlock(nil, nil, "SKYDOMES")
                page:newTextBlock(nil, nil, "Sets")
                item = page:CreateCustomFromConnectName("clouds2D.set", "Custom", { custom_init = customfunc_2dclouds_set_init,
                                                                    custom_render = customfunc_2dclouds_set_render,
                                                                    bypassConnect = true })
                --
                --item = page:AutoCreateFromConnectName("clouds2D.quality")
                --item:setTooltip("1: low (4k)\n2: mid (8k)\n3: high (16k)\n4: ultra (native)")
                
                item = page:AutoCreateFromConnectName("clouds2D.crossfade_time")
                item:setTooltip("Skydome textures are faded/crossfaded in this amount of time.")

                item = page:AutoCreateFromConnectName("clouds2D.wind_oscillation")
                item:setTooltip("Skydome rotation oscillation dependend on the wind speed.")

                h = page:getHPos()
                page:newTextBlock(nil, nil, "SHADOWS")

                item = page:AutoCreateFromConnectName("clouds_render.shadows_strength")
                item:setTooltip("-1 = Sun is always at 100%,\n0 = Only 3d cloud shadows are off,\n1 = Clouds shadows at 100%")

                if __CSP_version > 3629 then
                    item = page:AutoCreateFromConnectName("clouds_render.shadows_blur")
                    item:setTooltip("set the blurring of cloud shadows")
                end
                
                item = page:AutoCreateFromConnectName("clouds2D.advanced_shadows")
                item:setTooltip("A 3D clouds layer without visible clouds, but their shadows")
                if item:getConnectValue() then
                    page:newStateValue(nil,nil,"Clouds", "clouds.shadow", {position={100,h+5}})
                    page:newStateValue(nil,nil,"Skydome", "clouds.cover_shadow", {position={200,h+5}})

                    item = page:AutoCreateFromConnectName("clouds2D.advanced_shadows_sun_cover", {position={12,nil}})
                    item:setTooltip("Take the skydome's sun cover into account, when making 3d clouds shadows.")

                    item = page:AutoCreateFromConnectName("clouds2D.advanced_shadows_speed", {position={12,nil}})
                    item:setTooltip("A speed multiplier of those 3d cloud shadows")
                else
                    page:newStateValue(nil,nil,"Skydome", "clouds.cover_shadow", {position={100,h+5}})
                end

                page:newTextBlock(nil, nil, "MEMORY")

                --item = page:AutoCreateFromConnectName("clouds2D.preload")
                --item:setTooltip("Preload all textures to VRAM.\n\nNOT recommended to use!\n\nDue to asynchronous loading of the texture,\nAC's frame timing is not influenced")
                
                item = page:AutoCreateFromConnectName("clouds2D.unload")
                item:setTooltip("If selected, unused texture will be unloaded, to save VRAM.\nThey will be reloaded if needed.\nCSP 1.77p97 (1920) or higher needed!")
                page:newSeparator()
                page:newStateString(nil,nil, "", "clouds2D.info", {})

                page:newTextBlock(nil, nil, "CUSTOMIZATIONS")
                item = page:AutoCreateFromConnectName("clouds2D.brightness")
                item:setTooltip("A global custom brightness of the textures")
                item = page:AutoCreateFromConnectName("clouds2D.contrast")
                item:setTooltip("A global custom contrast of the textures")
            end
        elseif _l_clouds_render_method == 2 then
            -- check for clouds_render method and csp version
            if __CSP_version < 2234 then
                -- CSP lower 1.79
                page:newText(nil, nil, "You need at least CSP 1.79 for raymarching clouds!", {text_color=color_red} )
            else
                page:newTextBlock(nil, nil, "Shader Raymarching Clouds")
                page:newSeparator()
                page:AutoCreateAllFromMainCategory("clouds_raymarching", false, false) 
            end
        end
    else
        page:newText(nil, nil, "Clouds are not available in ECO mode...")
        page:shiftHPos(5)
        page:newText(nil, nil, "CM -> settings -> weatherFX -> Tweaks: Economic mode")
    end











    -- ###############
    -- # WEATHER
    -- ###############

    page = PureUIobj:newPage("Weather")

    page:newTextBlock(nil, nil, "WEATHER PARTICLES")

    item = page:AutoCreateFromConnectName("weather.use_weather_particles")

    page:newText(nil, nil, "If active, rain becomes snow with air temperatures below 3°C.")
    page:newText(nil, nil, "For \"Snow\" and \"Sleet\" weather, rain is always displayed as")
    page:newText(nil, nil, "snow, if weather particles are active.")

    page:shiftHPos(20)

    item = page:AutoCreateFromConnectName("weather.snow.size")
    item.power = 2

    item = page:AutoCreateFromConnectName("weather.ash.size")
    item.power = 2










    

    if not PureConfig_PPactivated() then

        -- ###############
        -- # PP off
        -- ###############

        page = PureUIobj:newPage("PPoff")

        page:newTextBlock(nil, nil, "Post Processing is deactivated")
        page:newTextBlock(nil, nil, "PP off Multiplier")
        page:AutoCreateAllFromMainCategory("ppoff", false, false)
    end

        --local n_customParameter = pureCustomScriptConnect:getParameterCount()
--[[
        if pure_WFX_STATE and pure_WFX_STATE:isConnected() then
            local script = pure_WFX_STATE:getString("PP.script")
            if script == "default_script.lua" then
                page:newText(nil, nil, "The current PP-filter has no Pure Script!", {text_color=color_orange} )
                page:newText(nil, nil, "The PP-filter may not function correctly with Pure!", {text_color=color_orange} )
            end
        end

        -- PP error messages
        item = page:newCustom("PP", "Errors", nil, "pp_errors", {   custom_init = customfunc_init_pp_errors,
                                                                    custom_render = customfunc_render_pp_errors,
                                                                    customConnect = nil,
                                                                    })

        local file = pure_WFX_STATE:getString("config.ppfilterrelatedfile")
        if file~=nil and file~="" then
            item = page:newCustom(nil,nil,nil,"ppfilter_related_file", {custom_render = customfunc_ppfilter_related_file, size={-1, 40}})
            item.ppfilter_related_file = string.gsub(file, ac.getFolder(ac.FolderID.Root), "")
        end

        group = page:newGroup(nil, nil, "PP adjustments")
        --group:setTooltip("Click to adjust the PostProcessing")
        page:AutoCreateAllFromMainCategory("pp", false, false, { group = group })
        --item = page:newSeparator()
        --group:addMember(item)


        page:AutoCreateAllFromMainCategory("pp", false, false)
]]
--[[
        if __CSP_version >= 2349 then

            -- CSP 0.1.80p204 (dynamic tonemapping)
            group = page:newGroup(nil, nil, "PP Tonemapping control", { custom_render = customfunc_tonemapping_group_render })
            -- collapsed state will be restored from ram backup, so it can be retrieved here
            local open = not group:isCollapsed()
            if open then
                --group:addMember(item)
                --group:setTooltip("Click to adjust the PostProcessing")
                local tmp = pure_WFX_STATE:getValue("PP.tonemapping")
                local customPP = pure_WFX_STATE:getValue("PP.customPP")

                local new_tonemapping = false
                if tmp == ac.TonemapFunction.Uchimura then
                    page:AutoCreateAllFromMainCategory("ppTonemapUchimura", false, false, { group = group })
                    new_tonemapping = true
                elseif tmp == ac.TonemapFunction.Lottes then
                    page:AutoCreateAllFromMainCategory("ppTonemapLottes", false, false, { group = group })
                    new_tonemapping = true
                elseif tmp >= customTonemapEnum.uniform and tmp <= customTonemapEnum.rgb then

                    item = page:newText(nil, nil, "Custom tonemapping is active. The values are stored in the script settings!")
                    group:addMember(item)

                    if n_customParameter > 0 then
                        for i=0,n_customParameter-1 do
                            local tmp = pureCustomScriptConnect:getItem(i)
                            if tmp~=nil then
                                if string.find(ffi.string(tmp.name), "TONEMAPPING__") then
                                    item = page:AutoCreateFromConnectID(i, {customConnect = pureCustomScriptConnect, custom_dirty = customfunc_custom_script_set_dirty})
                                    item.name = string.gsub(item.name, "TONEMAPPING__", "")
                                    group:addMember(item)
                                end
                            end
                        end
                    end
                    new_tonemapping = true
                end

                group:addMember(page:newSeparator(nil, nil))
    
                if new_tonemapping or customPP then
                    --page:AutoCreateAllFromMainCategory("ppTonemapUtils", false, false, { group = group })
                    item = page:AutoCreateFromConnectName("ppTonemapUtils.debug_clipping", { group = group })
                    item:setTooltip("Green = total black\nRed = above white")
                    item = page:AutoCreateFromConnectName("ppTonemapUtils.debug_curve", { group = group })
                    item:setTooltip("Show the tonmapping curve")
                    if item:getConnectValue() then
                        item = page:AutoCreateFromConnectName("ppTonemapUtils.debug_curve_X", { group = group })
                        item:setTooltip("Set the horizontal position")
                        item = page:AutoCreateFromConnectName("ppTonemapUtils.debug_curve_Y", { group = group })
                        item:setTooltip("Set the vertical position")
                        item = page:AutoCreateFromConnectName("ppTonemapUtils.debug_curve_SIZE", { group = group })
                        item:setTooltip("Set the size")
                    end
                else
                    item = page:newText(nil, nil, "No advanced tonemapping controls with old YEBIS.")
                    group:addMember(item)
                end
    
                item = page:newSeparator()
                group:addMember(item)
            end
        end
    else
        page:newTextBlock(nil, nil, "Post Processing is deactivated")
        page:newTextBlock(nil, nil, "PP off Multiplier")
        page:AutoCreateAllFromMainCategory("ppoff", false, false)
        page:newSeparator()
    end
    

    
    item = page:newButton("resetPure", nil, "Pure Script", {size={100,25}})
    item:setTooltip("Just resets Pure")
    h = page:getHPos() + 5
    page:newText(nil,nil,"Script loaded:", {position={0,h}})
    page:newStateString(nil,nil, "Script loaded", "PP.script", {position={105,h}})
    page:shiftHPos(20)

    if n_customParameter > 0 then
        
        local script_version = pureCustomScriptConnect:getWFXVersion()
        if script_version > 0 then
            h = page:getHPos()
            page:newText(nil,nil,"Script version:", {position={0,h}})
            page:newText(nil,nil,script_version, {position={105,h}})

            page:newStateString(nil,nil, "by", "PP.script.author", {position={150,h}})
        end

        page:shiftHPos(20)
        h = page:getHPos()-5

        page:newText(nil,nil,"Settings loaded:", {position={0,h}})
        page:newStateString(nil,nil, "", "config.usedscriptsettings", {position={105,h}})

        page:shiftHPos(25)

        -- custom script ui elements
        for i=0,n_customParameter-1 do
            local tmp = pureCustomScriptConnect:getItem(i)
            if tmp~=nil then
                if not string.find(ffi.string(tmp.name), "TONEMAPPING__") then
                    page:AutoCreateFromConnectID(i, {customConnect = pureCustomScriptConnect, custom_dirty = customfunc_custom_script_set_dirty})
                end
            end
        end
        
        if n_customParameter > 1 then
            -- script name is already a parameter

            page:shiftHPos(10)
            item = page:newButton("SCRIPTresetToDefaults", nil, "Reset Script Settings", {size={200,25}, background_color={0.2,0.3,0.4}})
            item:setTooltip("Resets only the Script's custom settings!")
            item = page:newButton("SCRIPTsave", nil, "Save Script Settings", {size={200,25}, custom_render = customfunc_custom_script_save_button_render})
            item:setTooltip("Saves only the Script's custom settings!")
            h = page:getHPos()
            item = page:newButton("SCRIPTload", nil, "Load Script Settings", {size={200,25}})
            item:setTooltip("Loads only the Script's custom settings!")
            item = page:newButton("SCRIPTdelete", nil, "Delete Script Settings", {size={200,25}, background_color={0.4,0.15,0.15}})
            item:setTooltip("Delete the current script settings file!")
            item = page:newText("SCRIPTdelete_text", nil, "A script settings file\ndoes not exist.", {position={40,h+8}, text_color={0.5,0.5,0.5}})
            item.hidden = true
        else
            page:newText(nil, nil, "No Script Controls")
        end

        if PureConfig_PPactivated() then

            page:newSeparator()
            item = page:newButton("SCRIPTexportPPFILTERconfig", nil, "Export Pure Config as PPfilter related config", {size={300,25}})
            item:setTooltip("Exports the current Pure Config as a ppfilter bound config. The file is placed in the \"pure_scripts\" folder.\nThis will load that config with the PPfilter!")
            h = page:getHPos()
            item = page:newButton("SCRIPTdeletePPFILTERconfig", nil, "Delete PPfilter related config", {size={300,25}})
            item:setTooltip("Delete a ppfilter bound config, if it exists.")
            item = page:newText("SCRIPTdeletePPFILTERconfig_text", nil, "A PPfilter related config does not exist.", {position={35,h+8}, text_color={0.5,0.5,0.5}})
            item.hidden = true
        end

        page:shiftHPos(20)
        page:newSeparator()
        page:newStateValue(nil,nil,"Script execution time", "PP.script.runtime", {unit="ms"})

    end
]]









    -- ###############
    -- # CAMERA 
    -- ###############

    page = PureUIobj:newPage("Camera")
    item = page:AutoCreateFromConnectName("camera.occlusion_control.adv_ambi_light")
    item:setTooltip("")

    item = page:AutoCreateFromConnectName("camera.occlusion_control.adv_fog_ambi_light")
    item:setTooltip("")

    item = page:AutoCreateFromConnectName("camera.occlusion_control.exposure")
    item:setTooltip("")

    item = page:AutoCreateFromConnectName("camera.occlusion_control.overcast")
    item:setTooltip("")

    item = page:AutoCreateFromConnectName("camera.occlusion_control.vao")
    item:setTooltip("")






    -- ###############
    -- # SOUND 
    -- ###############

    page = PureUIobj:newPage("Sound")
    item = page:AutoCreateFromConnectName("sound.wind_volume_interior")
    item = page:AutoCreateFromConnectName("sound.wind_volume_exterior")
    item = page:AutoCreateFromConnectName("sound.wind_volume_speed_damping")
    page:newSeparator()
    item = page:AutoCreateFromConnectName("sound.rain_volume_interior")
    item = page:AutoCreateFromConnectName("sound.rain_volume_exterior")
    item = page:AutoCreateFromConnectName("sound.rain_volume_speed_damping")
    page:newSeparator()
    item = page:AutoCreateFromConnectName("sound.damping_at_speed")
    item.format = "%.0f km/h"
    page:newSeparator()
    item = page:AutoCreateFromConnectName("sound.rain_volume_extra_skid")
    item = page:AutoCreateFromConnectName("sound.rain_volume_extra_wetness")
    item = page:AutoCreateFromConnectName("sound.rain_volume_extra_puddles")
    item = page:AutoCreateFromConnectName("sound.rain_volume_extra_gravel")
    page:newSeparator()
    item = page:AutoCreateFromConnectName("sound.thunder_volume_interior")
    item = page:AutoCreateFromConnectName("sound.thunder_volume_exterior")






    -- ###############
    -- # STATE 
    -- ###############

    page = PureUIobj:newPage("State")

    page:newText(nil, nil, "Stellar")
    h = page:getHPos() - 5
    page:newText(nil,nil,"Sun", {position={0,h}})
    page:newStateValue(nil,nil,"heading", "stellar.sun.heading", {position={40,h}, unit="°"})
    page:newStateValue(nil,nil,"angle", "stellar.sun.angle", {position={155,h}, unit="°"})
    page:newStateValue(nil,nil,"eclipse", "stellar.solar_eclipse", {position={252,h}})
    page:shiftHPos(15)
    h = page:getHPos() - 5
    page:newText(nil,nil,"Moon", {position={0,h}})
    page:newStateValue(nil,nil,"heading", "stellar.moon.heading", {position={40,h}, unit="°"})
    page:newStateValue(nil,nil,"angle", "stellar.moon.angle", {position={155,h}, unit="°"})
    page:newStateValue(nil,nil,"eclipse", "stellar.lunar_eclipse", {position={252,h}})
    page:shiftHPos(15)

    page:newSeparator()

    page:newText(nil, nil, "Weather")
    --h = page:getHPos() - 5
    page:newStateValue(nil,nil,"Current", "weather.current", {customValueConverter=customfunc_weather_id_converter})
    page:newStateValue(nil,nil,"Next", "weather.next", {customValueConverter=customfunc_weather_id_converter})
    page:newStateValue(nil,nil,"Transition", "weather.transition")
    --page:shiftHPos(15)

    page:newSeparator()



    page:newText(nil, nil, "Clouds")
    h = page:getHPos() - 5
    page:newStateValue(nil,nil,"Cells", "clouds.cell_count", {position={0,h}})
    page:newStateValue(nil,nil,"Subparts", "clouds.subpart_count", {position={75,h}})
    page:newStateValue(nil,nil,"AC Clouds", "clouds.ac_count", {position={180,h}})
    page:shiftHPos(15)
    h = page:getHPos()
    page:newText(nil, nil, "Cloud shadow at camera postition:")
    page:newStateValue(nil,nil,"", "clouds.shadow", {position={205,h}})

    page:newSeparator()

    page:newText(nil, nil, "Night Light Pollution")
    h = page:getHPos()
    page:newText(nil, nil, "Camera Position Relevance")
    page:newStateValue(nil,nil,"", "nlp.cam_pos_relevance", {position={165,h}})
    h = page:getHPos()
    page:newText(nil, nil, "Center")
    page:newStateValue(nil,nil,"X", "nlp.center.x", {position={50,h}, unit="m"})
    page:newStateValue(nil,nil,"Y", "nlp.center.y", {position={140,h}, unit="m"})
    page:newStateValue(nil,nil,"Z", "nlp.center.z", {position={230,h}, unit="m"})
    h = page:getHPos()
    page:newText(nil, nil, "Radius")
    page:newStateValue(nil,nil,"", "nlp.radius", {position={50,h}, unit="m"})
    h = page:getHPos()
    page:newText(nil, nil, "Density")
    page:newStateValue(nil,nil,"", "nlp.density", {position={50,h}})
    h = page:getHPos()
    page:newText(nil, nil, "Color")
    page:newStateValue(nil,nil,"R", "nlp.color.r", {position={50,h}})
    page:newStateValue(nil,nil,"G", "nlp.color.g", {position={110,h}})
    page:newStateValue(nil,nil,"B", "nlp.color.b", {position={170,h}})

    page:newSeparator()

    page:newText(nil, nil, "Cubemap Brightness Estimation")
    h = page:getHPos()
    page:newStateValue(nil,nil,"Minimum", "cbe.minimum")
    page:newStateValue(nil,nil,"Maximum", "cbe.maximum", {position={110,h}})
    page:newStateValue(nil,nil,"Average", "cbe.average", {position={225,h}})

    page:newSeparator()

    page:newText(nil, nil, "Track")
    h = page:getHPos()
    page:newText(nil, nil, "Orientation")
    page:newStateValue(nil,nil,"heading", "track.heading", {position={70,h}, unit="°"})

    page:newSeparator()

    page:newText(nil, nil, "Camera")
    h = page:getHPos()
    page:newText(nil, nil, "Orientation")
    page:newStateValue(nil,nil,"heading", "camera.orientation.heading", {position={70,h}, unit="°"})
    page:newStateValue(nil,nil,"angle", "camera.orientation.angle", {position={190,h}, unit="°"})
    h = page:getHPos()
    page:newText(nil, nil, "Position")
    page:newStateValue(nil,nil,"X", "camera.position.x", {position={70,h}, unit="m"})
    page:newStateValue(nil,nil,"Y", "camera.position.y", {position={170,h}, unit="m"})
    page:newStateValue(nil,nil,"Z", "camera.position.z", {position={270,h}, unit="m"})
    h = page:getHPos()
    page:newText(nil, nil, "Direction")
    page:newStateValue(nil,nil,"X", "camera.direction.x", {position={70,h}})
    page:newStateValue(nil,nil,"Y", "camera.direction.y", {position={170,h}})
    page:newStateValue(nil,nil,"Z", "camera.direction.z", {position={270,h}})
    h = page:getHPos()
    page:newText(nil, nil, "FOV")
    page:newStateValue(nil,nil,"", "camera.fov", {position={70,h}, unit="°"})
    h = page:getHPos()
    page:newText(nil, nil, "Movement")
    page:newStateValue(nil,nil,"X", "camera.moving.x", {position={70,h}, unit="m/f"})
    page:newStateValue(nil,nil,"Y", "camera.moving.y", {position={170,h}, unit="m/f"})
    page:newStateValue(nil,nil,"Z", "camera.moving.z", {position={270,h}, unit="m/f"})
    h = page:getHPos()
    page:newText(nil, nil, "Speed")
    page:newStateValue(nil,nil,"", "camera.speed", {position={70,h}, unit="km/h"})

    page:newSeparator()

    page:newText(nil, nil, "FPS")
    h = page:getHPos() - 5
    page:newStateValue(nil,nil,"sync", "fps.sync", {position={0,h}})
    page:newStateValue(nil,nil,"async", "fps.async", {position={120,h}})
    page:shiftHPos(15)











    -- ###############
    -- # TRACK
    -- ###############

    page = PureUIobj:newPage("Track")

    if PureConfig_getConnectTrack():isConnected() then

        -- Track info
        local coords = ac.getTrackCoordinatesDeg()
        local tmp_string = string.format("ID: %s, Layout: %s", ac.getTrackID(), ac.getTrackLayout())
        page:newText(nil, nil, tmp_string, {text_color={0.2,1.0,0.2}})
        if coords then
            tmp_string = string.format("Latitude: %.6f°, Longitude: %.6f°", coords.x, coords.y)
            page:newText(nil, nil, tmp_string, {text_color={0.2,1.0,0.2}})
        end

        -- STANDARD 

        group = page:newGroup(nil, nil, "Standard Track Adaptions")

        item = page:AutoCreateFromConnectName("FOG_SHAPE", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group })
        item.format = "%.1f"
        item.showModulationMultiplier = false
        item:setTooltip("For very small tracks with billboards, which faking distant object, you can gain this value. It will shorten the distant fog to reach this narrow billbords.\nFor real distant tracks (tracks with a real distant geometry), set this to -1!")               
        
        
        page:newSeparator(nil, nil, {group = group})
        
        item = page:AutoCreateFromConnectName("SMOG_MORNING", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item.format = "%.2f"
        item.showModulationMultiplier = false
        item:setTooltip("The avarage smog at early hours")


        item = page:AutoCreateFromConnectName("SMOG_NOON", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item.format = "%.2f"
        item.showModulationMultiplier = false
        item:setTooltip("The avarage smog at midday")
                                                       
        item = page:AutoCreateFromConnectName("SMOG_EVENING", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item.format = "%.2f"
        item.showModulationMultiplier = false
        item:setTooltip("The avarage smog at late hours")
              
        page:newSeparator(nil, nil, {group = group})
        
        item = page:AutoCreateFromConnectName("SUN_DAWN", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item.format = "%.1f"
        item.showModulationMultiplier = false
        item:setTooltip("Prevent speculars for sunrise. Speculars only appear above this angle.")
        
        item = page:AutoCreateFromConnectName("SUN_DUSK", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item.format = "%.1f"
        item.showModulationMultiplier = false
        item:setTooltip("Prevent speculars for sunset. Speculars only appear above this angle.")
        
        page:newSeparator(nil, nil, {group = group})
        
        item = page:AutoCreateFromConnectName("HUMIDITY_OFFSET", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item.format = "%.2f"
        item.showModulationMultiplier = false
        item:setTooltip("Set the avarage humidity of this track.")
         
        item = page:AutoCreateFromConnectName("HORIZON_OFFSET", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item.format = "%.1f"
        item.showModulationMultiplier = false
        item:setTooltip("Adjust the horizon line.")
                                                               
        item = page:AutoCreateFromConnectName("MINIMUM_GLOW_EMISSIVES", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item.format = "%.2f"
        item.showModulationMultiplier = false                                                    
        item:setTooltip("Set the minimum value of the glow emissives.")                    
        
        item = page:AutoCreateFromConnectName("TUNNEL_HELPER", { customConnect = PureConfig_getConnectTrack(),
        custom_dirty  = customfunc_track_set_dirty,
        group = group})
        item:setTooltip("Dimming sun, ambient and fog light, if the camera is in a tunnel.")

        -- LANDSCAPE

        group = page:newGroup(nil, nil, "Landscape")

        item = page:AutoCreateFromConnectName("LANDSCAPE_USE", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item:setTooltip("Add a fake landscape, to get a real horizon line.")

        -- colors
        page:newTextBlock(nil, nil, "Colors", {group = group})

        item = page:AutoCreateFromConnectName("LANDSCAPE_HUE", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item.format = "%.2f"
        item.showModulationMultiplier = false
        
        item = page:AutoCreateFromConnectName("LANDSCAPE_SATURATION", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item.format = "%.2f"
        item.showModulationMultiplier = false

        item = page:AutoCreateFromConnectName("LANDSCAPE_LEVEL", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item.format = "%.2f"
        item.showModulationMultiplier = false

        item = page:AutoCreateFromConnectName("LANDSCAPE_GAMMA", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item.format = "%.2f"
        item.showModulationMultiplier = false

        -- light 
        page:newTextBlock(nil, nil, "Light", {group = group})

        item = page:AutoCreateFromConnectName("LANDSCAPE_DIFFUSE", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item.format = "%.2f"
        item.showModulationMultiplier = false
        
        item = page:AutoCreateFromConnectName("LANDSCAPE_AMBIENT", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item.format = "%.2f"
        item.showModulationMultiplier = false

        -- position
        page:newTextBlock(nil, nil, "Position", {group = group})

        item = page:AutoCreateFromConnectName("LANDSCAPE_HEIGHT", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item.format = "%.2f"
        item.showModulationMultiplier = false
        
        item = page:AutoCreateFromConnectName("LANDSCAPE_COVER_NEGATIVE", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        
        --page:newText(nil, nil, "Landscape shader must not be a skyshader to use cover negative", {group = group})
                                                                

        item = page:AutoCreateFromConnectName("LANDSCAPE_SHIFT_X", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item.showModulationMultiplier = false

        item = page:AutoCreateFromConnectName("LANDSCAPE_SHIFT_Z", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item.showModulationMultiplier = false

        -- files
        page:newTextBlock(nil, nil, "File", {group = group})

        item = page:CreateCustomFromConnectName("LANDSCAPE_FILE", "Custom", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_init = customfunc_landscape_files_init,
                                                                custom_render = customfunc_landscape_files_render,
                                                                group = group,
                                                                bypassConnect = true })



        page:shiftHPos(5)
        page:newTextBlock(nil, nil, "Custom settings")
        item = page:newButton("TRACKsaveCustom", nil, "Save Custom Track Settings", {size={250,25}, custom_render = customfunc_track_save_custom_button_render})
        item:setTooltip("Saves your custom track settings")                                                            
        item = page:newButton("TRACKloadCustom", nil, "Load Custom Track Settings", {size={250,25}})
        item:setTooltip("Loads your Custom Track settings!")
        item = page:newButton("TRACKdeleteCustom", nil, "Delete Custom Track Settings", {size={250,25}, background_color={0.4,0.15,0.15}})
        item:setTooltip("Delete the custom track settings!")
    
    
        page:newTextBlock(nil, nil, "CSP track config")
        item = page:newButton("TRACKloadConfig", nil, "Load the Track's Config Settings", {size={250,25}})
        item:setTooltip("Loads the Pure settings from the track's config!")
        item = page:newButton("TRACKexportConfigClipboard", nil, "Copy Config Settings to clipboard", {size={250,25}, custom_handle=customfunc_ta_clipboard_internal})
        item:setTooltip("Click this and then open the track config and paste it there!")

    
        item = page:newButton("TRACKresetToDefaults", nil, "Reset Track Settings to Default", {size={250,25}, background_color={0.2,0.3,0.4}})
        item:setTooltip("Resets the track settings to defaults!")


        page:shiftHPos(5)
        page:newSeparator()

        -- GROUND FOG
        if ac.hasTrackSpline() then
            group = page:newGroup(nil, nil, "Groundfog Adaptions")

            item = page:newCustom("GROUNDFOG_FILE", "groundfog_editor", nil, "Groundfog Editor", {  --[[customConnect = PureConfig_getConnectTrack(),]]
                                                                                                    custom_init = customfunc_groundfog_init,
                                                                                                    custom_render = customfunc_groundfog_render,
                                                                                                    group = group,
                                                                                                    --[[bypassConnect = true]] })

            PureConfig_setTrackSplineEditing(not item.hidden)
        end
    end

    
    



    -- ###############
    -- # OPT / DEBUG
    -- ###############

    page = PureUIobj:newPage("Opt + Debug")

    page:newTextBlock(nil, nil, "Optimizations")
    item = page:AutoCreateFromConnectName("optimization.cpu_split")


    page:shiftHPos(20)

    page:newTextBlock(nil, nil, "Debug")

    item = page:AutoCreateFromConnectName("debug.memory")
    page:newStateString(nil,nil,"Runtime | collectgarbage", "debug.memory")

    page:shiftHPos(10)
    item = page:AutoCreateFromConnectName("debug.computation")

    page:shiftHPos(10)
    item = page:AutoCreateFromConnectName("debug.graphics")









    -- ###############
    -- # INFO
    -- ###############

    page = PureUIobj:newPage("Info")

    page:newTextBlock(nil, nil, "SLIDER EDIT", { text_color = {0.5,0.8,1.0} })

    page:shiftHPos(5)
    item = page:AutoCreateFromConnectName("info.test_slider", { custom_dirty = customfunc_custom_fake_dirty })
    page:shiftHPos(5)

    h = page:getHPos()
    page:newText(nil, nil, "Hold")
    page:newText(nil, nil, "SHIFT", { position={35,h}, text_color = {1.0,0.8,0.6} })
    page:newText(nil, nil, "to finetune.", { position={77,h}})
    h = page:getHPos()
    page:newText(nil, nil, "Use")
    page:newText(nil, nil, "CTRL", { position={35,h}, text_color = {1.0,0.8,0.6} })
    page:newText(nil, nil, "to input a specific value.", { position={77,h}})
    h = page:getHPos()
    page:newText(nil, nil, "Click the")
    page:newText(nil, nil, "RIGHT Mouse Button", { position={60,h}, text_color = {1.0,0.8,0.6} })
    page:newText(nil, nil, "to reset to the slider's default value.", { position={190,h}})
    page:shiftHPos(5)
    h = page:getHPos()
    page:newText(nil, nil, "If the slider's value is")
    page:newText(nil, nil, "not", { position={128,h}, text_color = {1,1,0.4} })
    page:newText(nil, nil, "at its", { position={150,h} })
    page:newText(nil, nil, "default value", { position={183,h}, text_color = {1,1,0.4} })
    page:newText(nil, nil, ",", { position={258,h} })
    h = page:getHPos()
    page:newText(nil, nil, "the sliders text will be displayed")
    page:newText(nil, nil, "yellow", { position={190,h}, text_color = {1,1,0.4} })
    page:newText(nil, nil, ".", { position={226,h} })

    
    page:shiftHPos(20)
    page:newText(nil, nil, "Config parameters can be changed by a script (PPfilter script)")

    page:shiftHPos(5)
    page:newText(nil, nil, "They can be changed realtively. So you can still change it,")
    h = page:getHPos()
    page:newText(nil, nil, "but the slider then acts as a multiplier. Displayed")
    page:newText(nil, nil, "blue", { position={289,h}, text_color = {0,0.75,1} })    
    item = page:AutoCreateFromConnectName("info.test_slider2", { custom_dirty = customfunc_custom_fake_dirty })

    page:shiftHPos(10)
    page:newText(nil, nil, "Or the script will change it absolutely")
    h = page:getHPos()
    page:newText(nil, nil, "and then you have no control over it. Displayed")
    page:newText(nil, nil, "orange", { position={280,h}, text_color = {1,0.5,0} }) 
    item = page:AutoCreateFromConnectName("info.test_slider3", { custom_dirty = customfunc_custom_fake_dirty })
    


























    -- ###############
    -- # SHADERS
    -- ###############
    
    page = PureUIobj:newPage("Shaders")

    if not eco then
        page:AutoCreateAllFromMainCategory("shaders", true, true, { built_groups = true, custom_group_render = customfunc_render_shader_groups})
        
        local lightning_group = page:getFirstElement("group", "lightning")
        if lightning_group and not lightning_group.collapsed then
            local first_of_lightning = lightning_group.members[1]

            local select = root_config_connect:getByName("consent.stroboscopic_selection")
            if select < 1 then
                if first_of_lightning~=nil then
                    -- active checkbox
                    first_of_lightning.hidden = true
                end
            end
            
            item = page:newCustom("Consent", "Strobo", root_config_connect:getIDByName("consent.stroboscopic"), "stroboscopic",
                                    {   custom_render = shader__strobo_render_func,
                                        customConnect = root_config_connect,
                                        size = {nil, 60}
                                    }
                                )
            item.active_checkbox = first_of_lightning
            
            page:moveBeforeElement(item, first_of_lightning)
            lightning_group:addMember(item, 1, false)
        end
    else
        page:newText(nil, nil, "Shaders are not available in ECO mode...")
        page:shiftHPos(5)
        page:newText(nil, nil, "CM -> settings -> weatherFX -> Tweaks: Economic mode")
    end
--[[
    page = PureUIobj:newPage("TEST")
    page:newRadioButton("radioTest", "", nil, "Title to show a title...", {background_color={0.2,0.5,0.2},
                                                                      choices = {"one", "ZWEI", "ldvslkkvlxkcjv"},
                                                                      colors = {rgb(1,0,0), rgb(0,1,0), rgb(0,0,1)}
                                                                    })
]]




    --local PP_name = "PP"
    --if not PureConfig_PPactivated() then PP_name = "PPoff" end

    tabbar = PureUIobj:newTabbar("Main", nil, {
        custom_handle = function(tabbar)
                            local tab = tabbar:getActiveTab()
                            if tab then
                                connect:addCommand("TabSelect", tab:getName())
                            end
                        end
    })
    tabbar:addTab("Main",       { sticker_color = {0.2, 0.2, 0.2,  0.0} })
    tabbar:addTab("AI",         { sticker_color = {0.5, 0.5, 0.5,  1.0} })
    tabbar:addTab("Light",      { sticker_color = {0.9, 0.7, 0.4,  1.0} })
    tabbar:addTab("Night",      { sticker_color = {0.1, 0.2, 0.3,  1.0} })
    tabbar:addTab("Sky",        { sticker_color = {0.1, 0.6, 0.8,  1.0} })
    if eco then
        tabbar:addTab("Clouds",     { sticker_color = {0.8, 0.8, 0.8,  1.0}, bg_color = {0.15, 0.15, 0.15, 1.0} , text_color = {0.3, 0.3, 0.3, 1.0} })
    else
        tabbar:addTab("Clouds",     { sticker_color = {0.8, 0.8, 0.8,  1.0} })
    end
    tabbar:addTab("Weather",    { sticker_color = {0.3, 0.5, 0.7,  1.0} })
    if not PureConfig_PPactivated() then
        tabbar:addTab("PPoff",         { sticker_color = {0.8, 0.2, 0.8,  1.0} })
    end
    if eco then
        tabbar:addTab("Shaders",    { sticker_color = {0.6, 0.2, 0.2,  1.0}, bg_color = {0.15, 0.15, 0.15, 1.0} , text_color = {0.3, 0.3, 0.3, 1.0}})
    else
        tabbar:addTab("Shaders",    { sticker_color = {0.6, 0.2, 0.2,  1.0}})
    end
    tabbar:addTab("Camera",     { sticker_color = {0.7, 0.5, 0.2,  1.0} })
    tabbar:addTab("Sound",      { sticker_color = {0.2, 0.5, 0.5,  1.0} })
    tabbar:addTab("State",      { sticker_color = {0.3, 0.8, 0.2,  1.0} })
    tabbar:addTab("Track",      { sticker_color = {0.3, 0.3, 0.3,  1.0} })
    tabbar:addTab("Opt + Debug",{ sticker_color = {0.1, 0.4, 0.1,  1.0} })
    tabbar:addTab("Info",       { sticker_color = {0.1, 0.1, 0.9,  1.0} })
    --tabbar:addTab("TEST",      { sticker_color = {0.1, 0.4, 0.1,  1.0} })

    tabbar:focusTabIfNoBackup("Main")
end








local function strobo_render_func(custom)
    if custom and custom.connect_id~=nil then
        local x = 0
        local y = ui.setCursorY(12)

        local w = ui.availableSpaceX() + 35
        local wh = w*0.5
        local h = ui.availableSpaceY()

        local pic_width = 100
        local zoom = pic_width/300
        _l_tmp_vec:set(300*zoom, 266*zoom)

        ui.setCursorX(wh-pic_width*0.5)
        ui.image(_l_strobo_image, _l_tmp_vec, full_trans_white)
        
        ui.pushFont(ui.Font.Title)

        ui.setCursorY(ui.getCursorY() + 12)
        ui.setCursorX(wh-145)
        ui.text("Pure's Lightning Shader can produce")
        ui.setCursorX(wh-90)
        ui.text("stroboscopic effects !!!")
        ui.setCursorX(wh-180)
        ui.text("This may not be safe for people with epilepsy!")

        ui.setCursorY(ui.getCursorY() + 20)

        local button_width = 300
        _l_tmp_vec:set(button_width, 40)
        local b_x = wh - 0.5*button_width + 4
        local selected = -1

        ui.setCursorX(b_x)
        ui.pushStyleColor(ui.StyleColor.Button, rgb.colors.cyan)
        if ui.button("Switch it off completely", _l_tmp_vec) then
            selected = 0
        end
        ui.popStyleColor(1)

        ui.setCursorX(b_x)
        ui.pushStyleColor(ui.StyleColor.Button, rgb.colors.green)
        if ui.button("Activate it, but no flashing effects", _l_tmp_vec) then
            selected = 1
        end
        ui.popStyleColor(1)

        ui.setCursorX(b_x)
        ui.pushStyleColor(ui.StyleColor.Button, rgb.colors.yellow)
        ui.pushStyleColor(ui.StyleColor.Text, rgb.colors.black)
        if ui.button("Activate it with full flashing effects", _l_tmp_vec) then
            selected = 2
        end
        ui.popStyleColor(2)



        if selected >= 0 then
            
            custom.customConnect:init(custom.connect_id+1, true)

            local select_id = custom.customConnect:getIDByName("consent.stroboscopic_selection")
            custom.customConnect:init(select_id+1, selected)

            local connect = custom.page.ui:getConnect()
            if connect then

                local active = false
                local speed = 0.25
                local max_flash = 5.0

                if selected < 1 then
                elseif selected < 2 then
                    active = true
                elseif selected > 1 then
                    active = true
                    speed = 0.9
                    max_flash = 7.5
                end

                connect:init(connect:getIDByName("shaders.lightning.active")+1, active)
                connect:init(connect:getIDByName("shaders.lightning.speed")+1, speed)
                connect:init(connect:getIDByName("shaders.lightning.maximum_flash_light")+1, max_flash)

                connect:addCommand("RootSave")
                connect:addCommand("SaveUserConfig")
                connect:addCommand("resetPure")
            end

        end
    end
end





local function createPureConfigUI__consent(PureUIobj)

    local root_config_connect = PureConfig_getConnectConfigRoot()
    local consent_strobo = root_config_connect:getByName("consent.stroboscopic")

    local page, h, item, h_e, tabbar, group
    local connect = PureUIobj:getConnect()

    page = PureUIobj:newPage("Consent")

    if not consent_strobo then
        -- stroboscopic
        item = page:newCustom("Consent", "Strobo", root_config_connect:getIDByName("consent.stroboscopic"), "stroboscopic",
                                                                    {   custom_render = strobo_render_func,
                                                                        customConnect = root_config_connect,
                                                                    })

    end



    local tabbar = PureUIobj:newTabbar("Main", nil)
    tabbar:addTab("Consent",       { sticker_color = {0.2, 0.2, 0.2,  0.0} })

    tabbar:focusTabIfNoBackup("Consent")


    

end


















































local function createPureLCSConfigUI__ok(PureUIobj)

    local page, h, item, h_e, tabbar, group
    local connect = PureUIobj:getConnect()

    local root_config_connect = PureConfig_getConnectConfigRoot()

    local eco = pure_WFX_STATE:getValue("settings.eco")

    -- ###############
    -- # MAIN 
    -- ###############
    page = PureUIobj:newPage("Main")

    if pure_WFX_STATE and pure_WFX_STATE:isConnected() then
        local script = pure_WFX_STATE:getString("PP.script")
        if script == "default_script.lua" then
            page:newText(nil, nil, "Pure's default PP-filter script is running...", {text_color=color_grey} )
            page:newText(nil, nil, "Screen, VR or HDR mode is managed automatically.", {text_color=color_grey} )
        end
    end

    wrong_settings = false
    wrong_settings_design(page, true)
    --recommended_settings_design(page, true)

    page:shiftHPos(10)



    local _l_clouds_render_method = PureUIobj.connect:getByName("clouds_render.method", false)

    if eco then
        page:newTextBlock(nil, nil, "Pure runs in economic mode...")
    else

        page:newTextBlock(nil, nil, "Quality Presets")

        _l_quali_button = 1 --set this variable to 1, it will raised by the buttons custom init function
        h = page:getHPos()
        h_e = 30
        item = page:newButton("qualityLOW", nil, "Low", {size={80,h_e},
                                                        position={3,h},
                                                        background_color={0.1,0.2,0.4},
                                                        custom_init = custominit_quality_buttons,
                                                        custom_render = customfunc_quality_buttons})
        local txt_groundfog = "Groundfog OFF"
        item:setTooltip(
            (_l_clouds_render_method > 0) and
                txt_groundfog
            or
                "Low 3D Clouds quality\n\n"..txt_groundfog
        )

        item = page:newButton("qualityMEDIUM", nil, "Medium", {size={80,h_e},
                                                        position={88,h},
                                                        background_color={0.2,0.4,0.1},
                                                        custom_init = custominit_quality_buttons,
                                                        custom_render = customfunc_quality_buttons})
        txt_groundfog = "Groundfog:\n✅ quality\n🟠 render distance\n❌ volumetric headlights\n❌ Car turbulences"
        item:setTooltip(
            (_l_clouds_render_method > 0) and
                txt_groundfog
            or
                "Medium 3D Clouds quality\n\n"..txt_groundfog
        )
        

        item = page:newButton("qualityHIGH", nil, "High", {size={80,h_e},
                                                        position={173,h},
                                                        background_color={0.4,0.3,0.1},
                                                        custom_init = custominit_quality_buttons,
                                                        custom_render = customfunc_quality_buttons})
        txt_groundfog = "Groundfog:\n✅ quality\n✅ render distance\n✅ volumetric headlights\n❌ Car turbulences"
        item:setTooltip(
            (_l_clouds_render_method > 0) and
                txt_groundfog
            or
                "High 3D Clouds quality\n\n"..txt_groundfog
        )

        item = page:newButton("qualityVERYHIGH", nil, "Very High", {size={80,h_e},
                                                        position={258,h},
                                                        background_color={0.4,0.1,0.1},
                                                        custom_init = custominit_quality_buttons,
                                                        custom_render = customfunc_quality_buttons})
        txt_groundfog = "Groundfog:\n✅ quality\n✅ render distance\n✅ volumetric headlights\n✅ Car turbulences"
        item:setTooltip(
            (_l_clouds_render_method > 0) and
                txt_groundfog
            or
                "Very high 3D Clouds quality\n\n"..txt_groundfog
        )

        page:shiftHPos(h_e + 5)
    end    
    

    
    
    page:newSeparator()
    page:newButton("resetPure", "", "Restart weatherFX system...")


    page:shiftHPos(10)

    page:newSeparator()
    page:newText(nil, nil, "Reset the Pure config to default values.")
    page:newText(nil, nil, "The config is not yet saved after this reset!")
    page:newText(nil, nil, "You can still load your settings again.")
    page:newButton("resetToDefaults", "", "Reset To Defaults")


    -- ###############
    -- # Config
    -- ###############
    page = PureUIobj:newPage("Config")

    page:newText(nil, nil, "CONTROLLED CONFIG LOADING SYSTEM" )

    page:shiftHPos(10)

    -- show config separation toogle
    page:newText(nil, nil, "Use multiple Pure configs for different video modes (VR + ppOff)." )
    item = page:AutoCreateFromConnectName("config.video_mode_separation", { customConnect = root_config_connect,
                                                                            custom_handle = function(obj) obj.customConnect:addCommand("RootSave") end
                                                                          })
    
    page:newStateString(nil,nil,"Current Config Video Mode", "config.usedfile")

    page:shiftHPos(10)


    page:newSeparator()


    local file = nil
    if PureConfig_PPactivated() then
        
        file = pure_WFX_STATE:getString("config.ppfilterrelatedfile")
        if file~=nil and file~="" then
            item = page:newCustom(nil,nil,nil,"ppfilter_related_file", {custom_render = customfunc_ppfilter_related_file, size={-1, 40}})
            item.ppfilter_related_file = string.gsub(file, ac.getFolder(ac.FolderID.Root), "")
        end

        if file~=nil and file~="" then
            item = page:newButton("SCRIPTdeletePPFILTERconfig", nil, "Delete PPfilter related config", {size={300,25}})
            item:setTooltip("Delete a ppfilter bound config, if it exists.")
        else
            item = page:newButton("SCRIPTexportPPFILTERconfig", nil, "Export Pure Config as PPfilter related config", {size={300,25}})
            item:setTooltip("Exports the current Pure Config as a ppfilter bound config. The file is placed in the \"purelcs_scripts\" folder.\nThis will load that config with the PPfilter!")
            item = page:newText("SCRIPTdeletePPFILTERconfig_text", nil, "A PPfilter related config does not exist.", {position={35,nil}, text_color={0.5,0.5,0.5}})
        end

        page:shiftHPos(10)
        page:newSeparator()
    end

    -- track specific loading
    if file == nil or file=="" then
        -- don't show it, if ppfilter related files are used

        page:newText(nil, nil, "Automatically load track specific config, if available." )
        item = page:AutoCreateFromConnectName("config.track_specific_loading", { customConnect = root_config_connect,
                                                                                custom_handle = function(obj) obj.customConnect:addCommand("RootSave") end
                                                                            })
        item:setTooltip("Automatic loading of the track specific config file at AC start.")

        item = page:AutoCreateFromConnectName("config.track_specific_video_separation", { customConnect = root_config_connect,
                                                                            custom_handle = function(obj) obj.customConnect:addCommand("RootSave") end
                                                                            })
        item:setTooltip("Creating track specific config files per video mode (default, VR or PP off)")
        
        local track_config = pure_WFX_STATE:getString("config.usedtrackfile")
        if track_config~=nil and track_config~="" then
            page:newStateString(nil,nil,"file", "config.usedtrackfile")

            item = page:newButton("saveTrackSpecific", "", "Save track specific config", {size={200, nil}, background_color={0.1,0.4,0.1}})
            item:setTooltip("Save a track specific config")
            item = page:newButton("loadTrackSpecific", "", "Load track specific config", {size={200, nil}, background_color={0.1,0.3,0.4}})
            item:setTooltip("Load the track specific config")
            item = page:newButton("deleteTrackSpecific", "", "Delete track specific config", {size={200, nil}, background_color={0.4,0.1,0.1}})
            item:setTooltip("Delete the track specific config")
        else
            page:newText(nil, nil, "The default Pure LCS config is used with this track.", {text_color={0.5,0.5,0.5}})

            item = page:newButton("saveTrackSpecific", "", "Save track specific config", {size={200, nil}, background_color={0.1,0.4,0.1}})
            item:setTooltip("Save a track specific config")
        end                                                                    
        
        
    else
        page:newText(nil, nil, "A ppfilter related config is loaded.\nTrack specific loading of configs is deactivated.", {text_color={0.5,0.5,0.5}})
    end




    -- ###############
    -- # PP 
    -- ###############

    --page = PureUIobj:newPage("PP")

    --local n_customParameter = pureCustomScriptConnect:getParameterCount()
--[[
    if PureConfig_PPactivated() then

        if pure_WFX_STATE and pure_WFX_STATE:isConnected() then
            local script = pure_WFX_STATE:getString("PP.script")

            if script == "default_script.lua" then

                local filter = pure_WFX_STATE:getString("PP.filter")
                local file = ac.getFolder(ac.FolderID.PPFilters).."\\pure_scripts\\"..filter..".lua"
                if file_exists(file) then
                    page:newText(nil, nil, "This PPfilter might only be compatible with Pure Gamma!", {text_color=color_orange} )
                    page:newText(nil, nil, "Pure's default PP-filter script is running...", {text_color=color_grey} )
                    page:newText(nil, nil, "Screen, VR or HDR mode is managed automatically.", {text_color=color_grey} )
                else
                    page:newText(nil, nil, "Pure's default PP-filter script is running...", {text_color=color_grey} )
                    page:newText(nil, nil, "Screen, VR or HDR mode is managed automatically.", {text_color=color_grey} )
                end
            else
                -- PP error messages
                item = page:newCustom("PP", "Errors", nil, "pp_errors", {   custom_init = customfunc_init_pp_errors,
                                                                            custom_render = customfunc_render_pp_errors,
                                                                            customConnect = nil,
                                                                            })
            end
        end

        local file = pure_WFX_STATE:getString("config.ppfilterrelatedfile")
        if file~=nil and file~="" then
            item = page:newCustom(nil,nil,nil,"ppfilter_related_file", {custom_render = customfunc_ppfilter_related_file, size={-1, 40}})
            item.ppfilter_related_file = string.gsub(file, ac.getFolder(ac.FolderID.Root), "")
        end
]]

--[[
        group = page:newGroup(nil, nil, "PP adjustments")
        --group:setTooltip("Click to adjust the PostProcessing")
        page:AutoCreateAllFromMainCategory("pp", false, false, { group = group })
        --item = page:newSeparator()
        --group:addMember(item)


        page:AutoCreateAllFromMainCategory("pp", false, false)
]]

--[[
        if __CSP_version >= 2349 then

            -- CSP 0.1.80p204 (dynamic tonemapping)
            group = page:newGroup(nil, nil, "PP Tonemapping control", { custom_render = customfunc_tonemapping_group_render })
            -- collapsed state will be restored from ram backup, so it can be retrieved here
            local open = not group:isCollapsed()
            if open then
                --group:addMember(item)
                --group:setTooltip("Click to adjust the PostProcessing")
                local tmp = pure_WFX_STATE:getValue("PP.tonemapping")
                local customPP = pure_WFX_STATE:getValue("PP.customPP")

                local new_tonemapping = false
                if tmp == ac.TonemapFunction.Uchimura then
                    page:AutoCreateAllFromMainCategory("ppTonemapUchimura", false, false, { group = group })
                    new_tonemapping = true
                elseif tmp == ac.TonemapFunction.Lottes then
                    page:AutoCreateAllFromMainCategory("ppTonemapLottes", false, false, { group = group })
                    new_tonemapping = true
                elseif tmp >= customTonemapEnum.uniform and tmp <= customTonemapEnum.rgb then

                    item = page:newText(nil, nil, "Custom tonemapping is active. The values are stored in the script settings!")
                    group:addMember(item)

                    if n_customParameter > 0 then
                        for i=0,n_customParameter-1 do
                            local tmp = pureCustomScriptConnect:getItem(i)
                            if tmp~=nil then
                                if string.find(ffi.string(tmp.name), "TONEMAPPING__") then
                                    item = page:AutoCreateFromConnectID(i, {customConnect = pureCustomScriptConnect, custom_dirty = customfunc_custom_script_set_dirty})
                                    item.name = string.gsub(item.name, "TONEMAPPING__", "")
                                    group:addMember(item)
                                end
                            end
                        end
                    end
                    new_tonemapping = true
                end

                group:addMember(page:newSeparator(nil, nil))
    
                if new_tonemapping or customPP then
                    --page:AutoCreateAllFromMainCategory("ppTonemapUtils", false, false, { group = group })
                    item = page:AutoCreateFromConnectName("ppTonemapUtils.debug_clipping", { group = group })
                    item:setTooltip("Green = total black\nRed = above white")
                    item = page:AutoCreateFromConnectName("ppTonemapUtils.debug_curve", { group = group })
                    item:setTooltip("Show the tonmapping curve")
                    if item:getConnectValue() then
                        item = page:AutoCreateFromConnectName("ppTonemapUtils.debug_curve_X", { group = group })
                        item:setTooltip("Set the horizontal position")
                        item = page:AutoCreateFromConnectName("ppTonemapUtils.debug_curve_Y", { group = group })
                        item:setTooltip("Set the vertical position")
                        item = page:AutoCreateFromConnectName("ppTonemapUtils.debug_curve_SIZE", { group = group })
                        item:setTooltip("Set the size")
                    end
                else
                    item = page:newText(nil, nil, "No advanced tonemapping controls with old YEBIS.")
                    group:addMember(item)
                end
    
                item = page:newSeparator()
                group:addMember(item)
            end
        end
    else
        page:newTextBlock(nil, nil, "Post Processing is deactivated")
        page:newTextBlock(nil, nil, "PP off Multiplier")
        page:AutoCreateAllFromMainCategory("ppoff", false, false)
        page:newSeparator()
    end
    

    
    item = page:newButton("resetPure", nil, "Pure Script", {size={100,25}})
    item:setTooltip("Just resets Pure")
    h = page:getHPos() + 5
    page:newText(nil,nil,"Script loaded:", {position={0,h}})
    page:newStateString(nil,nil, "Script loaded", "PP.script", {position={105,h}})
    page:shiftHPos(20)

    if n_customParameter > 0 then
        
        local script_version = pureCustomScriptConnect:getWFXVersion()
        if script_version > 0 then
            h = page:getHPos()
            page:newText(nil,nil,"Script version:", {position={0,h}})
            page:newText(nil,nil,script_version, {position={105,h}})

            page:newStateString(nil,nil, "by", "PP.script.author", {position={150,h}})
        end

        page:shiftHPos(20)
        h = page:getHPos()-5

        page:newText(nil,nil,"Settings loaded:", {position={0,h}})
        page:newStateString(nil,nil, "", "config.usedscriptsettings", {position={105,h}})

        page:shiftHPos(25)

        -- custom script ui elements
        for i=0,n_customParameter-1 do
            local tmp = pureCustomScriptConnect:getItem(i)
            if tmp~=nil then
                if not string.find(ffi.string(tmp.name), "TONEMAPPING__") then
                    page:AutoCreateFromConnectID(i, {customConnect = pureCustomScriptConnect, custom_dirty = customfunc_custom_script_set_dirty})
                end
            end
        end
        
        if n_customParameter > 1 then
            -- script name is already a parameter

            page:shiftHPos(10)
            item = page:newButton("SCRIPTresetToDefaults", nil, "Reset Script Settings", {size={200,25}, background_color={0.2,0.3,0.4}})
            item:setTooltip("Resets only the Script's custom settings!")
            item = page:newButton("SCRIPTsave", nil, "Save Script Settings", {size={200,25}, custom_render = customfunc_custom_script_save_button_render})
            item:setTooltip("Saves only the Script's custom settings!")
            h = page:getHPos()
            item = page:newButton("SCRIPTload", nil, "Load Script Settings", {size={200,25}})
            item:setTooltip("Loads only the Script's custom settings!")
            item = page:newButton("SCRIPTdelete", nil, "Delete Script Settings", {size={200,25}, background_color={0.4,0.15,0.15}})
            item:setTooltip("Delete the current script settings file!")
            item = page:newText("SCRIPTdelete_text", nil, "A script settings file\ndoes not exist.", {position={40,h+8}, text_color={0.5,0.5,0.5}})
            item.hidden = true
        else
            page:newText(nil, nil, "No Script Controls")
        end

        if PureConfig_PPactivated() then

            page:newSeparator()
            item = page:newButton("SCRIPTexportPPFILTERconfig", nil, "Export Pure Config as PPfilter related config", {size={300,25}})
            item:setTooltip("Exports the current Pure Config as a ppfilter bound config. The file is placed in the \"purelcs_scripts\" folder.\nThis will load that config with the PPfilter!")
            h = page:getHPos()
            item = page:newButton("SCRIPTdeletePPFILTERconfig", nil, "Delete PPfilter related config", {size={300,25}})
            item:setTooltip("Delete a ppfilter bound config, if it exists.")
            item = page:newText("SCRIPTdeletePPFILTERconfig_text", nil, "A PPfilter related config does not exist.", {position={35,h+8}, text_color={0.5,0.5,0.5}})
            item.hidden = true
        end

        page:shiftHPos(20)
        page:newSeparator()
        page:newStateValue(nil,nil,"Script execution time", "PP.script.runtime", {unit="ms"})




    end
]]







    -- ###############
    -- # LIGHT 
    -- ###############

    page = PureUIobj:newPage("Light")
    page:newTextBlock(nil, nil, "Daylight Multiplier")
    item = page:AutoCreateFromConnectName("light.daylight_multiplier")
    
    page:newTextBlock(nil, nil, "Sunlight")
    item = page:AutoCreateFromConnectName("light.sun.hue")
    item = page:AutoCreateFromConnectName("light.sun.saturation")
    item = page:AutoCreateFromConnectName("light.sun.level")
    item.power = 2.0
    item = page:AutoCreateFromConnectName("light.sun.speculars")

    page:newTextBlock(nil, nil, "Ambient Light")
    
    item = page:AutoCreateFromConnectName("light.ambient.hue")
    item = page:AutoCreateFromConnectName("light.ambient.saturation")
    item = page:AutoCreateFromConnectName("light.ambient.level")
    item.power = 2.0
    item = page:AutoCreateFromConnectName("light.ambient.minimum")

    page:newTextBlock(nil, nil, "Radiosity Ambient Light")
    item = page:AutoCreateFromConnectName("light.ambient_radiosity.hue")
    item = page:AutoCreateFromConnectName("light.ambient_radiosity.saturation")
    item = page:AutoCreateFromConnectName("light.ambient_radiosity.level")
    item.power = 2.0
    item = page:AutoCreateFromConnectName("light.ambient_radiosity.vao_exp")
    item = page:AutoCreateFromConnectName("light.ambient_radiosity.mix")
    
    page:newTextBlock(nil, nil, "Distant Ambient Light")
    item = page:AutoCreateFromConnectName("light.distant_ambient.hue")
    item = page:AutoCreateFromConnectName("light.distant_ambient.saturation")
    item = page:AutoCreateFromConnectName("light.distant_ambient.level")
    item.power = 2.0
    item = page:AutoCreateFromConnectName("light.distant_ambient.distance")
    

    page:newTextBlock(nil, nil, "Directional Ambient Light")
    item = page:AutoCreateFromConnectName("light.directional_ambient.hue")
    item = page:AutoCreateFromConnectName("light.directional_ambient.saturation")
    item = page:AutoCreateFromConnectName("light.directional_ambient.level")
    item.power = 2.0
    if __CSP_version >= 3092 then -- 0.2.4p45
        item = page:AutoCreateFromConnectName("light.directional_ambient.distance")
    end

    page:newTextBlock(nil, nil, "CSP GrassFX shading")
    item = page:AutoCreateFromConnectName("light.grass_shading.specularity")
    item = page:AutoCreateFromConnectName("light.grass_shading.reflectivity")
    item = page:AutoCreateFromConnectName("light.grass_shading.backlit")
    item = page:AutoCreateFromConnectName("light.grass_shading.saturation")

    page:newTextBlock(nil, nil, "CSP Lights")
    item = page:AutoCreateFromConnectName("csp_lights.bounce")
    item = page:AutoCreateFromConnectName("csp_lights.emissive")
    item = page:AutoCreateFromConnectName("csp_lights.true_emissive")
    item = page:AutoCreateFromConnectName("csp_lights.displays")
    item = page:AutoCreateFromConnectName("csp_lights.range")

    page:newTextBlock(nil, nil, "Reflections")
    item = page:AutoCreateFromConnectName("reflections.saturation")
    item = page:AutoCreateFromConnectName("reflections.level")
    --item = page:AutoCreateFromConnectName("reflections.emissive_boost")
    if __CSP_version >= 3435 then -- 0.2.9
        item = page:AutoCreateFromConnectName("reflections.sky.luminance")
        item.power = 2.0
        item = page:AutoCreateFromConnectName("reflections.sky.saturation")
        item = page:AutoCreateFromConnectName("reflections.sky.gamma")
    end

    page:newTextBlock(nil, nil, "VAO")
    --item = page:AutoCreateFromConnectName("vao.amount")
    item = page:AutoCreateFromConnectName("vao.track_exponent")
    item = page:AutoCreateFromConnectName("vao.dynamic_exponent")

    page:newTextBlock(nil, nil, "UI")
    item = page:AutoCreateFromConnectName("ui.white_reference_point")
    page:newStateValue(nil,nil,"White Reference Point", "ui.white_reference_point")



    

    -- ###############
    -- # SKY / NIGHT 
    -- ###############

    page = PureUIobj:newPage("Night|Sky")

    page:newTextBlock(nil, nil, "Sky")

    item = page:AutoCreateFromConnectName("sky.saturation")
    item = page:AutoCreateFromConnectName("sky.level")

    page:newTextBlock(nil, nil, "Sun/Moon")

    item = page:AutoCreateFromConnectName("sun.sun_moon_size")


    page:newTextBlock(nil, nil, "Night")
    page:shiftHPos(5)

    page:newText(nil, nil, "Night Light Pollution Multipliers")
    item = page:AutoCreateFromConnectName("nlp.level")
    item = page:AutoCreateFromConnectName("nlp.density")

    page:newSeparator()

    page:newText(nil, nil, "Night Light Pollution")
    h = page:getHPos()
    page:newText(nil, nil, "Camera Position Relevance")
    page:newStateValue(nil,nil,"", "nlp.cam_pos_relevance", {position={165,h}})
    h = page:getHPos()
    page:newText(nil, nil, "Center")
    page:newStateValue(nil,nil,"X", "nlp.center.x", {position={50,h}, unit="m"})
    page:newStateValue(nil,nil,"Y", "nlp.center.y", {position={140,h}, unit="m"})
    page:newStateValue(nil,nil,"Z", "nlp.center.z", {position={230,h}, unit="m"})
    h = page:getHPos()
    page:newText(nil, nil, "Radius")
    page:newStateValue(nil,nil,"", "nlp.radius", {position={50,h}, unit="m"})
    h = page:getHPos()
    page:newText(nil, nil, "Density")
    page:newStateValue(nil,nil,"", "nlp.density", {position={50,h}})
    h = page:getHPos()
    page:newText(nil, nil, "Color")
    page:newStateValue(nil,nil,"R", "nlp.color.r", {position={50,h}})
    page:newStateValue(nil,nil,"G", "nlp.color.g", {position={110,h}})
    page:newStateValue(nil,nil,"B", "nlp.color.b", {position={170,h}})

    page:shiftHPos(20)
    page:newTextBlock(nil, nil, "Lowest Ambient Light")
    item = page:AutoCreateFromConnectName("nlp.lowest_ambient")

    page:shiftHPos(20)
    page:newTextBlock(nil, nil, "Moon")
    item = page:AutoCreateFromConnectName("moon.no_shadows")
    item:setTooltip("Moonlight will not cast shadows (more fps)")
    item = page:AutoCreateFromConnectName("moon.light")
    item:setTooltip("Set the brightness of the moonlight.")
    item = page:AutoCreateFromConnectName("moon.appearance")
    item:setTooltip("Set the brightness of the moon appearance.")

    page:newTextBlock(nil, nil, "Stars")
    item = page:AutoCreateFromConnectName("stars.appearance")
    item.power = 3
    item:setTooltip("Set the brightness of the stars.")
    item = page:AutoCreateFromConnectName("stars.dynamic_adaption")
    item:setTooltip("If Pure's exposure calculation is used,\nthe exposure is used to improve\nthe star's light dynamics.")






    -- ###############
    -- # FOG
    -- ###############

    page = PureUIobj:newPage("Fog")

    page:newTextBlock(nil, nil, "Far structure")
    item = page:AutoCreateFromConnectName("fog.far.distance")
    item.power = 3
    item = page:AutoCreateFromConnectName("fog.far.blend")
    item.power = 3
    item = page:AutoCreateFromConnectName("fog.far.exponent")
    item.power = 3

    page:newTextBlock(nil, nil, "Far fog color")
    item = page:AutoCreateFromConnectName("fog.far.color.hue")
    item = page:AutoCreateFromConnectName("fog.far.color.saturation")
    item = page:AutoCreateFromConnectName("fog.far.color.level")

    page:newTextBlock(nil, nil, "Near structure")
    item = page:AutoCreateFromConnectName("fog.near.distance")
    item.power = 3
    item = page:AutoCreateFromConnectName("fog.near.blend")
    item.power = 3
    item = page:AutoCreateFromConnectName("fog.near.exponent")
    item.power = 3
    item = page:AutoCreateFromConnectName("fog.near.height")
    item.power = 3

    page:newTextBlock(nil, nil, "Near fog color")
    item = page:AutoCreateFromConnectName("fog.near.color.hue")
    item = page:AutoCreateFromConnectName("fog.near.color.saturation")
    item = page:AutoCreateFromConnectName("fog.near.color.level")


    page:newTextBlock(nil, nil, "Parts")
    item = page:AutoCreateFromConnectName("fog.atmosphere")
    item = page:AutoCreateFromConnectName("fog.sky")
    item.power = 3

    page:newTextBlock(nil, nil, "Backlit")
    item = page:AutoCreateFromConnectName("fog.backlit_level")
    item = page:AutoCreateFromConnectName("fog.backlit_exponent")

    page:newTextBlock(nil, nil, "Render")
    item = page:AutoCreateFromConnectName("fog.cubemaps")








    -- ###############
    -- # CLOUDS
    -- ###############
    
    page = PureUIobj:newPage("Clouds")

    if not eco then

        page:newTextBlock(nil, nil, "Clouds Render Method")
        item = page:AutoCreateFromConnectName("clouds_render.method")
        item:setTooltip("0: 3D bilboard clouds / multi layer\n1: 360° Skydomes")

        
        local _l_clouds_render_method = PureUIobj.connect:getByName("clouds_render.method", false)
        if _l_clouds_render_method == 0 then
            -- 3D clouds
            page:newTextBlock(nil, nil, "3D clouds")

        elseif _l_clouds_render_method == 1 then
            -- 2D clouds

            -- check for clouds_render method and csp version
            if __CSP_version < 1992 then
                -- CSP lower 1.77 and 2dclouds
                page:newText(nil, nil, "You need at least CSP 1.78 for skydomes!", {text_color=color_red} )
            else
        
                page:newTextBlock(nil, nil, "SKYDOMES")
                page:newTextBlock(nil, nil, "Sets")
                item = page:CreateCustomFromConnectName("clouds2D.set", "Custom", { custom_init = customfunc_2dclouds_set_init,
                                                                    custom_render = customfunc_2dclouds_set_render,
                                                                    bypassConnect = true })
                --
                --item = page:AutoCreateFromConnectName("clouds2D.quality")
                --item:setTooltip("1: low (4k)\n2: mid (8k)\n3: high (16k)\n4: ultra (native)")
                
                item = page:AutoCreateFromConnectName("clouds2D.crossfade_time")
                item:setTooltip("Skydome textures are faded/crossfaded in this amount of time.")

                item = page:AutoCreateFromConnectName("clouds2D.wind_oscillation")
                item:setTooltip("Skydome rotation oscillation dependend on the wind speed.")

                h = page:getHPos()
                page:newTextBlock(nil, nil, "SHADOWS")

                item = page:AutoCreateFromConnectName("clouds_render.shadows_strength")
                item:setTooltip("-1 = Sun is always at 100%,\n0 = Only 3d cloud shadows are off,\n1 = Clouds shadows at 100%")

                if __CSP_version > 3629 then
                    item = page:AutoCreateFromConnectName("clouds_render.shadows_blur")
                    item:setTooltip("set the blurring of cloud shadows")
                end
                
                item = page:AutoCreateFromConnectName("clouds2D.advanced_shadows")
                item:setTooltip("A 3D clouds layer without visible clouds, but their shadows")
                if item:getConnectValue() then
                    page:newStateValue(nil,nil,"Clouds", "clouds.shadow", {position={100,h+5}})
                    page:newStateValue(nil,nil,"Skydome", "clouds.cover_shadow", {position={200,h+5}})

                    item = page:AutoCreateFromConnectName("clouds2D.advanced_shadows_sun_cover", {position={12,nil}})
                    item:setTooltip("Take the skydome's sun cover into account, when making 3d clouds shadows.")

                    item = page:AutoCreateFromConnectName("clouds2D.advanced_shadows_speed", {position={12,nil}})
                    item:setTooltip("A speed multiplier of those 3d cloud shadows")
                else
                    page:newStateValue(nil,nil,"Skydome", "clouds.cover_shadow", {position={100,h+5}})
                end

                page:newTextBlock(nil, nil, "MEMORY")

                --item = page:AutoCreateFromConnectName("clouds2D.preload")
                --item:setTooltip("Preload all textures to VRAM.\n\nNOT recommended to use!\n\nDue to asynchronous loading of the texture,\nAC's frame timing is not influenced")
                
                item = page:AutoCreateFromConnectName("clouds2D.unload")
                item:setTooltip("If selected, unused texture will be unloaded, to save VRAM.\nThey will be reloaded if needed.\nCSP 1.77p97 (1920) or higher needed!")
                page:newSeparator()
                page:newStateString(nil,nil, "", "clouds2D.info", {})

                page:newTextBlock(nil, nil, "CUSTOMIZATIONS")
                item = page:AutoCreateFromConnectName("clouds2D.brightness")
                item:setTooltip("A global custom brightness of the textures")
                item = page:AutoCreateFromConnectName("clouds2D.contrast")
                item:setTooltip("A global custom contrast of the textures")
        
            end
        
        end
    else
        page:newText(nil, nil, "Clouds are not available in ECO mode...")
        page:shiftHPos(5)
        page:newText(nil, nil, "CM -> settings -> weatherFX -> Tweaks: Economic mode")
    end










    -- ###############
    -- # WEATHER
    -- ###############

    page = PureUIobj:newPage("Weather")

    page:newTextBlock(nil, nil, "WEATHER PARTICLES")

    item = page:AutoCreateFromConnectName("weather.use_weather_particles")

    page:newText(nil, nil, "If active, rain becomes snow with air temperatures below 3°C.")
    page:newText(nil, nil, "For \"Snow\" and \"Sleet\" weather, rain is always displayed as")
    page:newText(nil, nil, "snow, if weather particles are active.")

    page:shiftHPos(20)
    
    item = page:AutoCreateFromConnectName("weather.snow.size")
    item.power = 2

    item = page:AutoCreateFromConnectName("weather.ash.size")
    item.power = 2

    page:newSeparator()

    page:shiftHPos(5)

    page:newText(nil, nil, "ONLINE SESSION WEATHER")

    item = page:AutoCreateFromConnectName("weather.add_online_properties")
    item:setTooltip("Adds humidity and mist properties in online sessions.\nThe settings from Pure Planner's weather presets\nwill be used.")




    -- ###############
    -- # SCENE
    -- ###############

    page = PureUIobj:newPage("Scene")

    item = page:AutoCreateFromConnectName("World.brightness")
    item.power = 2

    item = page:AutoCreateFromConnectName("Scene.brightness")
    item.power = 2

    page:newSeparator()

    page:newText(nil, nil, "Cubemap Brightness Estimation")
    h = page:getHPos()
    page:newStateValue(nil,nil,"Minimum", "cbe.minimum")
    page:newStateValue(nil,nil,"Maximum", "cbe.maximum", {position={110,h}})
    page:newStateValue(nil,nil,"Average", "cbe.average", {position={225,h}})

    page:shiftHPos(10)
    page:newText(nil,nil, "AE - CBE balance")
    item = page:AutoCreateFromConnectName("Scene.CBE_usage")

    page:shiftHPos(10)
    h = page:getHPos()
    page:newStateValue(nil,nil,"CBE exp.", "CBE.exposure", {text_color = {0.5,0.75,1.00}})
    page:newStateValue(nil,nil,"AE exp.", "AE.exposure", {position={110,h}, text_color = {1.00,0.75,0.5}})
    page:newStateValue(nil,nil,"| AE target", "AE.target", {position={200,h}, text_color = {1.00,0.75,0.5}})

    h = page:getHPos()
    page:newStateValue(nil,nil,"Final exposure", "FINAL.exposure", {text_color = {0.5,1.00,0.75}})

    page:shiftHPos(10)
    page:newTextBlock(nil,nil, "Helper")
    page:newStateValue(nil,nil,"track tunnel helper multiplier", "track.tunnel_helper")
    item = page:AutoCreateFromConnectName("Scene.tunnel_sunlight_dimmer")
    item = page:AutoCreateFromConnectName("Scene.tunnel_ambilight_dimmer")
    item = page:AutoCreateFromConnectName("Scene.tunnel_fog_dimmer")

    page:shiftHPos(10)
    page:newText(nil, nil, "Camera Occlusion states")
    h = page:getHPos()
    page:newStateValue(nil,nil,"Occlusion", "camera.occlusion", {position={0,h}})
    page:newStateValue(nil,nil,"in tunnel", "camera.inTunnel", {position={120,h}})

    page:shiftHPos(30)
    item = page:AutoCreateFromConnectName("Scene.emissive_adaption")


    -- ###############
    -- # AI
    -- ###############

    page = PureUIobj:newPage("AI")

    page:newStateValue(nil,nil,"Sun angle", "stellar.sun.angle")
    item = page:AutoCreateFromConnectName("AI_headlights.sun")
    item:setTooltip("If the altidute of the sun is under this value, headlights will be switched on.")

    page:newStateValue(nil,nil,"Ambient Luminance", "ambient.luminance")
    item = page:AutoCreateFromConnectName("AI_headlights.ambient_light")
    item:setTooltip("If ambient luminance is under this value, headlights will be switched on.")

    page:newStateValue(nil,nil,"Cubemap Brightness Estimation", "cbe.average")
    item = page:AutoCreateFromConnectName("AI_headlights.CBE")
    item:setTooltip("If CBE is under this value, headlights will be switched on.")

    page:newStateValue(nil,nil,"Fog Dense", "fog.dense")
    item = page:AutoCreateFromConnectName("AI_headlights.fog")
    item:setTooltip("If fog is over this value, headlights will be switched on.")

    page:newStateValue(nil,nil,"Rain Intensity", "rain.intensity")
    item = page:AutoCreateFromConnectName("AI_headlights.rain")
    item.power = 3
    item:setTooltip("If rain intensity is over this value, headlights will be switched on.")

    page:shiftHPos(10)

    if PURE_CONFIG__get_HeadlightsControl() then
        
        page:newTextBlock(nil,nil, "Headlights and high beams control")
        page:newText(nil,nil, "If set to Pure, the lights are strictly controlled by Pure!", {text_color = {0.5,0.5,0.5}})
        page:newText(nil,nil, "If set to Default, the lights are controlled by CSP (automatic or player control),", {text_color = {0.5,0.5,0.5}})
        page:newText(nil,nil, "except in replays, then Pure will control it.", {text_color = {0.5,0.5,0.5}})
        page:newText(nil,nil, "High beams are not controlled by Pure.", {text_color = {0.5,0.5,0.5}})

        page:shiftHPos(10)
        h = page:getHPos()

        local tmp_headlights = connect:getByName("AI_headlights.headlights_ctrl")
        if tmp_headlights~=nil then
            PURE_CONFIG__set_cars_headlights(tmp_headlights)
        end
        tmp_headlights = connect:getByName("AI_headlights.high_beams_ctrl")
        if tmp_headlights~=nil then
            PURE_CONFIG__set_cars_high_beams(tmp_headlights)
        end

        page:newButton(nil,nil, "Headlights Pure", {
            custom_dirty=function(e)
                custom_dirty_high_beams_check(e, PURE_CONFIG__get_cars_headlights()==100)
            end,
            custom_handle=function(e)
                PURE_CONFIG__set_cars_headlights(100)
            end,
            position={0, h},
            size={150, 30},
        })

        page:newButton(nil,nil, "Headlights Default", {
            custom_dirty=function(e)
                custom_dirty_headlights_check(e, PURE_CONFIG__get_cars_headlights()==ac.SceneTweakFlag.Default)
            end,
            custom_handle=function(e)
                PURE_CONFIG__set_cars_headlights(ac.SceneTweakFlag.Default)
            end,
            position={0, h + 35},
            size={150, 30},
        })

        page:newButton(nil,nil, "Headlights Force On", {
            custom_dirty=function(e)
                custom_dirty_high_beams_check(e, PURE_CONFIG__get_cars_headlights()==ac.SceneTweakFlag.ForceOn)
            end,
            custom_handle=function(e)
                PURE_CONFIG__set_cars_headlights(ac.SceneTweakFlag.ForceOn)
            end,
            position={0, h + 70},
            size={150, 30},
        })

        page:newButton(nil,nil, "Headlights Force Off", {
            custom_dirty=function(e)
                custom_dirty_high_beams_check(e, PURE_CONFIG__get_cars_headlights()==ac.SceneTweakFlag.ForceOff)
            end,
            custom_handle=function(e)
                PURE_CONFIG__set_cars_headlights(ac.SceneTweakFlag.ForceOff)
            end,
            position={0, h + 105},
            size={150, 30},
        })


        page:newButton(nil,nil, "High Beams Default", {
            custom_dirty=function(e)
                custom_dirty_high_beams_check(e, PURE_CONFIG__get_cars_high_beams()==ac.SceneTweakFlag.Default)
            end,
            custom_handle=function(e)
                PURE_CONFIG__set_cars_high_beams(ac.SceneTweakFlag.Default)
            end,
            position={170, h + 35},
            size={150, 30},
        })

        page:newButton(nil,nil, "High Beams Force On", {
            custom_dirty=function(e)
                custom_dirty_high_beams_check(e, PURE_CONFIG__get_cars_high_beams()==ac.SceneTweakFlag.ForceOn)
            end,
            custom_handle=function(e)
                PURE_CONFIG__set_cars_high_beams(ac.SceneTweakFlag.ForceOn)
            end,
            position={170, h + 70},
            size={150, 30},
        })

        page:newButton(nil,nil, "High Beams Force Off", {
            custom_dirty=function(e)
                custom_dirty_high_beams_check(e, PURE_CONFIG__get_cars_high_beams()==ac.SceneTweakFlag.ForceOff)
            end,
            custom_handle=function(e)
                PURE_CONFIG__set_cars_high_beams(ac.SceneTweakFlag.ForceOff)
            end,
            position={170, h + 105},
            size={150, 30},
        })

        page:newButton(nil, nil, "Deactivate Headlights control", {
            background_color={0.5,0.2,0.2},
            custom_handle = function()
                local _l_CSP_MODUL_WEATHERFX = ac.INIConfig.cspModule(ac.CSPModuleID.WeatherFX)
                _l_CSP_MODUL_WEATHERFX:setAndSave("MISCELLANEOUS","SWITCH_HEADLIGHTS_WITH_AI", 0)
                PureUIobj:resetDesign()
            end,
            position={0, h + 150},
            size={320, 30},
        })
    else
        page:newTextBlock(nil,nil, "To control headlights, \"Turn headlights on and off automatically\"")
        page:newText(nil,nil, "must be activated in:")
        page:newText(nil,nil, "Content Manager")
        page:newText(nil,nil, "\t->SETTINGS")
        page:newText(nil,nil, "\t\t->Custom Shaders Patch")
        page:newText(nil,nil, "\t\t\t->WeatherFX")
        page:newButton(nil, nil, "Activate Headlights control", {
            background_color={0.2,0.5,0.2},
            custom_handle = function()
                local _l_CSP_MODUL_WEATHERFX = ac.INIConfig.cspModule(ac.CSPModuleID.WeatherFX)
                _l_CSP_MODUL_WEATHERFX:setAndSave("MISCELLANEOUS","SWITCH_HEADLIGHTS_WITH_AI", 1)
                PureUIobj:resetDesign()
            end
        })
    end





    



    -- ###############
    -- # SOUND 
    -- ###############

    page = PureUIobj:newPage("Sound")
    item = page:AutoCreateFromConnectName("sound.wind_volume_interior")
    item = page:AutoCreateFromConnectName("sound.wind_volume_exterior")
    item = page:AutoCreateFromConnectName("sound.wind_volume_speed_damping")
    page:newSeparator()
    item = page:AutoCreateFromConnectName("sound.rain_volume_interior")
    item = page:AutoCreateFromConnectName("sound.rain_volume_exterior")
    item = page:AutoCreateFromConnectName("sound.rain_volume_speed_damping")
    page:newSeparator()
    item = page:AutoCreateFromConnectName("sound.damping_at_speed")
    item.format = "%.0f km/h"
    page:newSeparator()
    item = page:AutoCreateFromConnectName("sound.rain_volume_extra_skid")
    item = page:AutoCreateFromConnectName("sound.rain_volume_extra_wetness")
    item = page:AutoCreateFromConnectName("sound.rain_volume_extra_puddles")
    item = page:AutoCreateFromConnectName("sound.rain_volume_extra_gravel")
    page:newSeparator()
    item = page:AutoCreateFromConnectName("sound.thunder_volume_interior")
    item = page:AutoCreateFromConnectName("sound.thunder_volume_exterior")









    -- ###############
    -- # STATE 
    -- ###############

    page = PureUIobj:newPage("State")

    page:newText(nil, nil, "Stellar")
    h = page:getHPos() - 5
    page:newText(nil,nil,"Sun", {position={0,h}})
    page:newStateValue(nil,nil,"heading", "stellar.sun.heading", {position={40,h}, unit="°"})
    page:newStateValue(nil,nil,"angle", "stellar.sun.angle", {position={155,h}, unit="°"})
    page:newStateValue(nil,nil,"eclipse", "stellar.solar_eclipse", {position={252,h}})
    page:shiftHPos(15)
    h = page:getHPos() - 5
    page:newText(nil,nil,"Moon", {position={0,h}})
    page:newStateValue(nil,nil,"heading", "stellar.moon.heading", {position={40,h}, unit="°"})
    page:newStateValue(nil,nil,"angle", "stellar.moon.angle", {position={155,h}, unit="°"})
    page:newStateValue(nil,nil,"eclipse", "stellar.lunar_eclipse", {position={252,h}})
    page:shiftHPos(15)

    page:newSeparator()

    page:newText(nil, nil, "Weather")
    --h = page:getHPos() - 5
    page:newStateValue(nil,nil,"Current", "weather.current", {customValueConverter=customfunc_weather_id_converter})
    page:newStateValue(nil,nil,"Next", "weather.next", {customValueConverter=customfunc_weather_id_converter})
    page:newStateValue(nil,nil,"Transition", "weather.transition")
    --page:shiftHPos(15)

    page:newSeparator()



    page:newText(nil, nil, "Clouds")
    h = page:getHPos() - 5
    page:newStateValue(nil,nil,"Cells", "clouds.cell_count", {position={0,h}})
    page:newStateValue(nil,nil,"Subparts", "clouds.subpart_count", {position={75,h}})
    page:newStateValue(nil,nil,"AC Clouds", "clouds.ac_count", {position={180,h}})
    page:shiftHPos(15)
    h = page:getHPos()
    page:newText(nil, nil, "Cloud shadow at camera postition:")
    page:newStateValue(nil,nil,"", "clouds.shadow", {position={205,h}})

    page:newSeparator()


    page:newText(nil, nil, "Night Light Pollution")
    h = page:getHPos()
    page:newText(nil, nil, "Camera Position Relevance")
    page:newStateValue(nil,nil,"", "nlp.cam_pos_relevance", {position={165,h}})
    h = page:getHPos()
    page:newText(nil, nil, "Center")
    page:newStateValue(nil,nil,"X", "nlp.center.x", {position={50,h}, unit="m"})
    page:newStateValue(nil,nil,"Y", "nlp.center.y", {position={140,h}, unit="m"})
    page:newStateValue(nil,nil,"Z", "nlp.center.z", {position={230,h}, unit="m"})
    h = page:getHPos()
    page:newText(nil, nil, "Radius")
    page:newStateValue(nil,nil,"", "nlp.radius", {position={50,h}, unit="m"})
    h = page:getHPos()
    page:newText(nil, nil, "Density")
    page:newStateValue(nil,nil,"", "nlp.density", {position={50,h}})
    h = page:getHPos()
    page:newText(nil, nil, "Color")
    page:newStateValue(nil,nil,"R", "nlp.color.r", {position={50,h}})
    page:newStateValue(nil,nil,"G", "nlp.color.g", {position={110,h}})
    page:newStateValue(nil,nil,"B", "nlp.color.b", {position={170,h}})

    page:newSeparator()

    page:newText(nil, nil, "Cubemap Brightness Estimation")
    h = page:getHPos()
    page:newStateValue(nil,nil,"Minimum", "cbe.minimum")
    page:newStateValue(nil,nil,"Maximum", "cbe.maximum", {position={110,h}})
    page:newStateValue(nil,nil,"Average", "cbe.average", {position={225,h}})

    page:newSeparator()

    page:newText(nil, nil, "Track")
    h = page:getHPos()
    page:newText(nil, nil, "Orientation")
    page:newStateValue(nil,nil,"heading", "track.heading", {position={70,h}, unit="°"})

    page:newSeparator()

    page:newText(nil, nil, "Camera")
    h = page:getHPos()
    page:newText(nil, nil, "Orientation")
    page:newStateValue(nil,nil,"heading", "camera.orientation.heading", {position={70,h}, unit="°"})
    page:newStateValue(nil,nil,"angle", "camera.orientation.angle", {position={190,h}, unit="°"})
    h = page:getHPos()
    page:newText(nil, nil, "Position")
    page:newStateValue(nil,nil,"X", "camera.position.x", {position={70,h}, unit="m"})
    page:newStateValue(nil,nil,"Y", "camera.position.y", {position={170,h}, unit="m"})
    page:newStateValue(nil,nil,"Z", "camera.position.z", {position={270,h}, unit="m"})
    h = page:getHPos()
    page:newText(nil, nil, "Direction")
    page:newStateValue(nil,nil,"X", "camera.direction.x", {position={70,h}})
    page:newStateValue(nil,nil,"Y", "camera.direction.y", {position={170,h}})
    page:newStateValue(nil,nil,"Z", "camera.direction.z", {position={270,h}})
    h = page:getHPos()
    page:newText(nil, nil, "FOV")
    page:newStateValue(nil,nil,"", "camera.fov", {position={70,h}, unit="°"})
    h = page:getHPos()
    page:newText(nil, nil, "Movement")
    page:newStateValue(nil,nil,"X", "camera.moving.x", {position={70,h}, unit="m/f"})
    page:newStateValue(nil,nil,"Y", "camera.moving.y", {position={170,h}, unit="m/f"})
    page:newStateValue(nil,nil,"Z", "camera.moving.z", {position={270,h}, unit="m/f"})
    h = page:getHPos()
    page:newText(nil, nil, "Speed")
    page:newStateValue(nil,nil,"", "camera.speed", {position={70,h}, unit="km/h"})

    page:newSeparator()

--[[
    page:newText(nil, nil, "FPS")
    h = page:getHPos() - 5
    page:newStateValue(nil,nil,"sync", "fps.sync", {position={0,h}})
    page:newStateValue(nil,nil,"async", "fps.async", {position={120,h}})
    page:shiftHPos(15)
]]










    -- ###############
    -- # TRACK
    -- ###############

    page = PureUIobj:newPage("Track")

    if PureConfig_getConnectTrack():isConnected() then

        -- Track info
        local coords = ac.getTrackCoordinatesDeg()
        local tmp_string = string.format("ID: %s, Layout: %s", ac.getTrackID(), ac.getTrackLayout())
        page:newText(nil, nil, tmp_string, {text_color={0.2,1.0,0.2}})
        if coords then
            tmp_string = string.format("Latitude: %.6f°, Longitude: %.6f°", coords.x, coords.y)
            page:newText(nil, nil, tmp_string, {text_color={0.2,1.0,0.2}})
        end

        -- STANDARD 

        group = page:newGroup(nil, nil, "Standard Track Adaptions")

        item = page:AutoCreateFromConnectName("FOG_SHAPE", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group })
        item.format = "%.1f"
        item.showModulationMultiplier = false
        item:setTooltip("For very small tracks with billboards, which faking distant object, you can gain this value. It will shorten the distant fog to reach this narrow billbords.\nFor real distant tracks (tracks with a real distant geometry), set this to -1!")                       
        
        page:newSeparator(nil, nil, {group = group})
        
        item = page:AutoCreateFromConnectName("SMOG_MORNING", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item.format = "%.2f"
        item.showModulationMultiplier = false
        item:setTooltip("The avarage smog at early hours")


        item = page:AutoCreateFromConnectName("SMOG_NOON", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item.format = "%.2f"
        item.showModulationMultiplier = false
        item:setTooltip("The avarage smog at midday")
                                                       
        item = page:AutoCreateFromConnectName("SMOG_EVENING", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item.format = "%.2f"
        item.showModulationMultiplier = false
        item:setTooltip("The avarage smog at late hours")
              
        page:newSeparator(nil, nil, {group = group})
        
        item = page:AutoCreateFromConnectName("SUN_DAWN", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item.format = "%.1f"
        item.showModulationMultiplier = false
        item:setTooltip("Prevent speculars for sunrise. Speculars only appear above this angle.")
        
        item = page:AutoCreateFromConnectName("SUN_DUSK", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item.format = "%.1f"
        item.showModulationMultiplier = false
        item:setTooltip("Prevent speculars for sunset. Speculars only appear above this angle.")
        
        page:newSeparator(nil, nil, {group = group})
        
        item = page:AutoCreateFromConnectName("HUMIDITY_OFFSET", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item.format = "%.2f"
        item.showModulationMultiplier = false
        item:setTooltip("Set the avarage humidity of this track.")
         
        item = page:AutoCreateFromConnectName("HORIZON_OFFSET", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item.format = "%.1f"
        item.showModulationMultiplier = false
        item:setTooltip("Adjust the horizon line.")


        item = page:AutoCreateFromConnectName("TUNNEL_HELPER", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item:setTooltip("Dimming sun, ambient and fog light, if the camera is in a tunnel.")

--[[                                                               
        item = page:AutoCreateFromConnectName("MINIMUM_GLOW_EMISSIVES", { customConnect = PureConfig_getConnectTrack(),
                                                                custom_dirty  = customfunc_track_set_dirty,
                                                                group = group})
        item.format = "%.2f"
        item.showModulationMultiplier = false                                                    
        item:setTooltip("Set the minimum value of the glow emissives.")                    
]]        


        -- LANDSCAPE
        if not eco then
            group = page:newGroup(nil, nil, "Landscape")

            item = page:AutoCreateFromConnectName("LANDSCAPE_USE", { customConnect = PureConfig_getConnectTrack(),
                                                                    custom_dirty  = customfunc_track_set_dirty,
                                                                    group = group})
            item:setTooltip("Add a fake landscape, to get a real horizon line.")

            -- colors
            page:newTextBlock(nil, nil, "Colors", {group = group})

            item = page:AutoCreateFromConnectName("LANDSCAPE_HUE", { customConnect = PureConfig_getConnectTrack(),
                                                                    custom_dirty  = customfunc_track_set_dirty,
                                                                    group = group})
            item.format = "%.2f"
            item.showModulationMultiplier = false
            
            item = page:AutoCreateFromConnectName("LANDSCAPE_SATURATION", { customConnect = PureConfig_getConnectTrack(),
                                                                    custom_dirty  = customfunc_track_set_dirty,
                                                                    group = group})
            item.format = "%.2f"
            item.showModulationMultiplier = false

            item = page:AutoCreateFromConnectName("LANDSCAPE_LEVEL", { customConnect = PureConfig_getConnectTrack(),
                                                                    custom_dirty  = customfunc_track_set_dirty,
                                                                    group = group})
            item.format = "%.2f"
            item.showModulationMultiplier = false

            item = page:AutoCreateFromConnectName("LANDSCAPE_GAMMA", { customConnect = PureConfig_getConnectTrack(),
                                                                    custom_dirty  = customfunc_track_set_dirty,
                                                                    group = group})
            item.format = "%.2f"
            item.showModulationMultiplier = false

            -- light 
            page:newTextBlock(nil, nil, "Light", {group = group})

            item = page:AutoCreateFromConnectName("LANDSCAPE_DIFFUSE", { customConnect = PureConfig_getConnectTrack(),
                                                                    custom_dirty  = customfunc_track_set_dirty,
                                                                    group = group})
            item.format = "%.2f"
            item.showModulationMultiplier = false
            
            item = page:AutoCreateFromConnectName("LANDSCAPE_AMBIENT", { customConnect = PureConfig_getConnectTrack(),
                                                                    custom_dirty  = customfunc_track_set_dirty,
                                                                    group = group})
            item.format = "%.2f"
            item.showModulationMultiplier = false

            -- position
            page:newTextBlock(nil, nil, "Position", {group = group})

            item = page:AutoCreateFromConnectName("LANDSCAPE_HEIGHT", { customConnect = PureConfig_getConnectTrack(),
                                                                    custom_dirty  = customfunc_track_set_dirty,
                                                                    group = group})
            item.format = "%.2f"
            item.showModulationMultiplier = false
            
            --item = page:AutoCreateFromConnectName("LANDSCAPE_COVER_NEGATIVE", { customConnect = PureConfig_getConnectTrack(),
            --                                                        custom_dirty  = customfunc_track_set_dirty,
            --                                                        group = group})
            
            --page:newText(nil, nil, "Landscape shader must not be a skyshader to use cover negative", {group = group})
                                                                    

            item = page:AutoCreateFromConnectName("LANDSCAPE_SHIFT_X", { customConnect = PureConfig_getConnectTrack(),
                                                                    custom_dirty  = customfunc_track_set_dirty,
                                                                    group = group})
            item.showModulationMultiplier = false

            item = page:AutoCreateFromConnectName("LANDSCAPE_SHIFT_Z", { customConnect = PureConfig_getConnectTrack(),
                                                                    custom_dirty  = customfunc_track_set_dirty,
                                                                    group = group})
            item.showModulationMultiplier = false

            -- files
            page:newTextBlock(nil, nil, "File", {group = group})

            item = page:CreateCustomFromConnectName("LANDSCAPE_FILE", "Custom", { customConnect = PureConfig_getConnectTrack(),
                                                                    custom_init = customfunc_landscape_files_init,
                                                                    custom_render = customfunc_landscape_files_render,
                                                                    group = group,
                                                                    bypassConnect = true })

        end

        page:shiftHPos(5)
        page:newTextBlock(nil, nil, "Custom settings")
        item = page:newButton("TRACKsaveCustom", nil, "Save Custom Track Settings", {size={250,25}, custom_render = customfunc_track_save_custom_button_render})
        item:setTooltip("Saves your custom track settings")                                                            
        item = page:newButton("TRACKloadCustom", nil, "Load Custom Track Settings", {size={250,25}})
        item:setTooltip("Loads your Custom Track settings!")
        item = page:newButton("TRACKdeleteCustom", nil, "Delete Custom Track Settings", {size={250,25}, background_color={0.4,0.15,0.15}})
        item:setTooltip("Delete the custom track settings!")
    
    
        page:newTextBlock(nil, nil, "CSP track config")
        item = page:newButton("TRACKloadConfig", nil, "Load the Track's Config Settings", {size={250,25}})
        item:setTooltip("Loads the Pure settings from the track's config!")
        item = page:newButton("TRACKexportConfigClipboard", nil, "Copy Config Settings to clipboard", {size={250,25}, custom_handle=customfunc_ta_clipboard_internal})
        item:setTooltip("Click this and then open the track config and paste it there!")

    
        item = page:newButton("TRACKresetToDefaults", nil, "Reset Track Settings to Default", {size={250,25}, background_color={0.2,0.3,0.4}})
        item:setTooltip("Resets the track settings to defaults!")


        page:shiftHPos(5)
        page:newSeparator()


        if not eco then
            -- GROUND FOG
            if ac.hasTrackSpline() then
                group = page:newGroup(nil, nil, "Groundfog Adaptions")

                item = page:newCustom("GROUNDFOG_FILE", "groundfog_editor", nil, "Groundfog Editor", {  custom_init = customfunc_groundfog_init,
                                                                                                        custom_render = customfunc_groundfog_render,
                                                                                                        group = group,
                                                                                                    })

                PureConfig_setTrackSplineEditing(not item.hidden)
            end
        end
    end







    -- ###############
    -- # OPT / DEBUG
    -- ###############

    page = PureUIobj:newPage("Opt + Debug")

    --page:newTextBlock(nil, nil, "Optimizations")
    --item = page:AutoCreateFromConnectName("optimization.cpu_split")


    --page:shiftHPos(20)

    page:newTextBlock(nil, nil, "Debug")

    item = page:AutoCreateFromConnectName("debug.memory")
    page:newStateString(nil,nil,"Runtime | collectgarbage", "debug.memory")

    --page:shiftHPos(10)
    --item = page:AutoCreateFromConnectName("debug.computation")

    --page:shiftHPos(10)
    --item = page:AutoCreateFromConnectName("debug.graphics")









    -- ###############
    -- # INFO
    -- ###############

    page = PureUIobj:newPage("Info")

    page:newTextBlock(nil, nil, "SLIDER EDIT", { text_color = {0.5,0.8,1.0} })

    page:shiftHPos(5)
    item = page:AutoCreateFromConnectName("info.test_slider", { custom_dirty = customfunc_custom_fake_dirty })
    page:shiftHPos(5)

    h = page:getHPos()
    page:newText(nil, nil, "Hold")
    page:newText(nil, nil, "SHIFT", { position={35,h}, text_color = {1.0,0.8,0.6} })
    page:newText(nil, nil, "to finetune.", { position={77,h}})
    h = page:getHPos()
    page:newText(nil, nil, "Use")
    page:newText(nil, nil, "CTRL", { position={35,h}, text_color = {1.0,0.8,0.6} })
    page:newText(nil, nil, "to input a specific value.", { position={77,h}})
    h = page:getHPos()
    page:newText(nil, nil, "Click the")
    page:newText(nil, nil, "RIGHT Mouse Button", { position={60,h}, text_color = {1.0,0.8,0.6} })
    page:newText(nil, nil, "to reset to the slider's default value.", { position={190,h}})
    page:shiftHPos(5)
    h = page:getHPos()
    page:newText(nil, nil, "If the slider's value is")
    page:newText(nil, nil, "not", { position={128,h}, text_color = {1,1,0.4} })
    page:newText(nil, nil, "at its", { position={150,h} })
    page:newText(nil, nil, "default value", { position={183,h}, text_color = {1,1,0.4} })
    page:newText(nil, nil, ",", { position={258,h} })
    h = page:getHPos()
    page:newText(nil, nil, "the sliders text will be displayed")
    page:newText(nil, nil, "yellow", { position={190,h}, text_color = {1,1,0.4} })
    page:newText(nil, nil, ".", { position={226,h} })

    
    page:shiftHPos(20)
    page:newText(nil, nil, "Config parameters can be changed by a script (PPfilter script)")

    page:shiftHPos(5)
    page:newText(nil, nil, "They can be changed realtively. So you can still change it,")
    h = page:getHPos()
    page:newText(nil, nil, "but the slider then acts as a multiplier. Displayed")
    page:newText(nil, nil, "blue", { position={289,h}, text_color = {0,0.75,1} })    
    item = page:AutoCreateFromConnectName("info.test_slider2", { custom_dirty = customfunc_custom_fake_dirty })

    page:shiftHPos(10)
    page:newText(nil, nil, "Or the script will change it absolutely")
    h = page:getHPos()
    page:newText(nil, nil, "and then you have no control over it. Displayed")
    page:newText(nil, nil, "orange", { position={280,h}, text_color = {1,0.5,0} }) 
    item = page:AutoCreateFromConnectName("info.test_slider3", { custom_dirty = customfunc_custom_fake_dirty })








    -- ###############
    -- # SHADERS
    -- ###############
    
    page = PureUIobj:newPage("Shaders")

    if not eco then
        page:AutoCreateAllFromMainCategory("shaders", true, true, { built_groups = true, custom_group_render = customfunc_render_shader_groups})
        
        local lightning_group = page:getFirstElement("group", "lightning")
        if lightning_group and not lightning_group.collapsed then
            local first_of_lightning = lightning_group.members[1]

            local select = root_config_connect:getByName("consent.stroboscopic_selection")
            if select < 1 then
                if first_of_lightning~=nil then
                    -- active checkbox
                    first_of_lightning.hidden = true
                end
            end
            
            item = page:newCustom("Consent", "Strobo", root_config_connect:getIDByName("consent.stroboscopic"), "stroboscopic",
                                    {   custom_render = shader__strobo_render_func,
                                        customConnect = root_config_connect,
                                        size = {nil, 60}
                                    }
                                )
            item.active_checkbox = first_of_lightning
            
            page:moveBeforeElement(item, first_of_lightning)
            lightning_group:addMember(item, 1, false)
        end
    else
        page:newText(nil, nil, "Shaders are not available in ECO mode...")
        page:shiftHPos(5)
        page:newText(nil, nil, "CM -> settings -> weatherFX -> Tweaks: Economic mode")
    end









    tabbar = PureUIobj:newTabbar("Main", nil, {
        custom_handle = function(tabbar)
                            local tab = tabbar:getActiveTab()
                            if tab then
                                connect:addCommand("TabSelect", tab:getName())
                            end
                        end
    })
    tabbar:addTab("Main",       { sticker_color = {0.2, 0.2, 0.2,  0.0} })
    tabbar:addTab("Config",     { sticker_color = {0.9, 0.1, 0.1,  1.0} })
    --tabbar:addTab("PP",         { sticker_color = {0.8, 0.2, 0.8,  1.0} })
    tabbar:addTab("Light",      { sticker_color = {0.9, 0.7, 0.4,  1.0} })
    tabbar:addTab("Night|Sky",  { sticker_color = {0.1, 0.2, 0.3,  1.0} })
    if eco then
        tabbar:addTab("Clouds",     { sticker_color = {0.8, 0.8, 0.8,  1.0}, bg_color = {0.15, 0.15, 0.15, 1.0} , text_color = {0.3, 0.3, 0.3, 1.0} })
    else
        tabbar:addTab("Clouds",     { sticker_color = {0.8, 0.8, 0.8,  1.0} })
    end
    tabbar:addTab("Fog",        { sticker_color = {0.7, 0.7, 0.7,  1.0} })
    tabbar:addTab("Weather",    { sticker_color = {0.3, 0.5, 0.7,  1.0} })
    tabbar:addTab("Scene",      { sticker_color = {0.3, 0.9, 0.3,  1.0} })
    if eco then
        tabbar:addTab("Shaders",    { sticker_color = {0.6, 0.2, 0.2,  1.0}, bg_color = {0.15, 0.15, 0.15, 1.0} , text_color = {0.3, 0.3, 0.3, 1.0}})
    else
        tabbar:addTab("Shaders",    { sticker_color = {0.6, 0.2, 0.2,  1.0}})
    end
    tabbar:addTab("Sound",      { sticker_color = {0.2, 0.5, 0.5,  1.0} })
    tabbar:addTab("AI",         { sticker_color = {0.5, 0.5, 0.5,  1.0} })
    tabbar:addTab("State",      { sticker_color = {0.3, 0.8, 0.2,  1.0} })
    tabbar:addTab("Track",      { sticker_color = {0.3, 0.3, 0.3,  1.0} })
    tabbar:addTab("Opt + Debug",{ sticker_color = {0.1, 0.4, 0.1,  1.0} })
    tabbar:addTab("Info",       { sticker_color = {0.1, 0.1, 0.9,  1.0} })

    tabbar:focusTabIfNoBackup("Main")
end





















function createPureConfigUI(PureUIobj)
      
    local root_config_connect = PureConfig_getConnectConfigRoot()
    local consent = root_config_connect:getByName("consent.stroboscopic")

    local style = get_style()


    if style == "Pure LCS" then
        if consent then
            createPureLCSConfigUI__ok(PureUIobj)
        else
            createPureConfigUI__consent(PureUIobj)
        end
    else
        if consent then
            createPureConfigUI__ok(PureUIobj)
        else
            createPureConfigUI__consent(PureUIobj)
        end
    end
end























function createPureNotSelectedUI(PureUIobj)

    local page, h, item, h_e, tabbar, group

    page = PureUIobj:newPage("noPure")
    page:newTextBlock(nil, nil, "Pure weather script is not running!")
    page:newButton("activatePureWeatherScript", "", "Activate Pure", {background_color={0.2,0.5,0.2}})
    page:shiftHPos(5)
    page:newText(nil, nil, "Or")
    page:newText(nil, nil, "Select \"Pure\" as weather script in\nContent Manager\n\t> Settings\n\t\t> Custom Shaders Patch\n\t\t\t> Weather FX")
    
    page:shiftHPos(80)
    page:newTextBlock(nil, nil, "If you already selected \"Pure\",\nbut the weather script changes back,\nplease do those 3 steps:")

    page:shiftHPos(30)
    page:newText(nil, nil, "1.)\tDeactivate Microsoft Ondrive for your\n\t\t \"C:\\Users\\xxxxxxxx\\Documents\\Assetto Corsa\" folder.")
    page:shiftHPos(12)
    page:newText(nil, nil, "\t\tOR")
    page:newText(nil, nil, "\t\tUninstall Microsoft Ondrive")

    page:shiftHPos(10)
    page:newText(nil, nil, "2.)\tDelete those 2 files:")
    page:newText(nil, nil, "\t\t- ..\\Documents\\Assetto Corsa\\cfg\\extension\\weather_fx.ini")
    page:newText(nil, nil, "\t\t- ..\\steamapps\\common\\extension\\config\\weather_fx.ini")

    page:shiftHPos(10)
    page:newText(nil, nil, "3.)\tReinstall Custom Shaders Patch:")
    page:newText(nil, nil, "\t\tContent Manager\n\t\t\t> Settings\n\t\t\t\t> Custom Shaders Patch\n\t\t\t\t\t> About&update\n\t\t\t\t\t\t\"Reinstall Current Version\"")

    tabbar = PureUIobj:newTabbar("Main", false) -- do not backup tab selection / its just a temporary tab 
    tabbar:addTab("noPure",       { sticker_color = {1.0, 0.0, 0.0,  0.0} })
    tabbar:focusTabIfNoBackup("noPure")
end